/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.xtend.ast;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.eclipse.internal.xtend.expression.ast.DeclaredParameter;
import org.eclipse.internal.xtend.expression.ast.Expression;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.internal.xtend.xtend.ast.AbstractExtensionDefinition;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionExtensionStatement
extends AbstractExtensionDefinition {
    private final Expression expression;
    private final Stack<List<Type>> analyzations = new Stack();

    public ExpressionExtensionStatement(Identifier name, Identifier returnType, List<DeclaredParameter> formalParameters, Expression expression, boolean cached, boolean isPrivate) {
        super(name, returnType, formalParameters, cached, isPrivate);
        this.expression = expression;
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public Object evaluateInternal(Object[] parameters, ExecutionContext ctx) {
        return this.evaluateInternal2(parameters, ctx);
    }

    protected Object evaluateInternal2(Object[] parameters, ExecutionContext ctx) {
        ctx = ctx.cloneWithoutVariables();
        ctx = ctx.cloneWithResource(this.file);
        List<String> paramNames = this.getParameterNames();
        int i = 0;
        int x = paramNames.size();
        while (i < x) {
            String name = paramNames.get(i);
            ctx = ctx.cloneWithVariable(new Variable(name, parameters[i]));
            ++i;
        }
        return this.expression.evaluate(ctx);
    }

    @Override
    public void analyzeInternal(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        if (this.expression != null) {
            this.expression.analyze(ctx, issues);
        }
    }

    @Override
    protected Type internalGetReturnType(Type[] parameters, ExecutionContext ctx, Set<AnalysationIssue> issues) {
        if (this.getReturnTypeIdentifier() != null) {
            return ctx.getTypeForName(this.getReturnTypeIdentifier().getValue());
        }
        if (parameters == null || parameters.length != this.getParameterNames().size()) {
            return null;
        }
        List<Type> params = Arrays.asList(parameters);
        if (!this.analyzations.contains(params)) {
            this.analyzations.push(params);
            try {
                Type type = this.analyzeInternal(parameters, ctx, issues);
                return type;
            }
            finally {
                this.analyzations.pop();
            }
        }
        if (this.returnType == null) {
            issues.add(new AnalysationIssue(AnalysationIssue.INTERNAL_ERROR, "Recursive extensions need to have a return type specified!", this));
            return null;
        }
        return ctx.getTypeForName(this.returnType.getValue());
    }

    protected Type analyzeInternal(Type[] parameters, ExecutionContext ctx, Set<AnalysationIssue> issues) {
        ctx = ctx.cloneWithoutVariables();
        ctx = ctx.cloneWithResource(this.file);
        List<String> paramNames = this.getParameterNames();
        int i = 0;
        int x = paramNames.size();
        while (i < x) {
            String name = paramNames.get(i);
            Type t = parameters[i];
            ctx = ctx.cloneWithVariable(new Variable(name, t));
            ++i;
        }
        return this.expression.analyze(ctx, issues);
    }
}

