/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.jet.internal.JETActivatorWrapper;
import org.eclipse.jet.internal.SavedStateManager;
import org.eclipse.jet.internal.core.ContextLogEntryFactoryManager;
import org.eclipse.jet.internal.core.IContextLogEntryFactory;
import org.eclipse.jet.internal.core.equinox.EquinoxContextLogEntryFactory;
import org.eclipse.jet.internal.extensionpoints.ModelInspectorsManager;
import org.eclipse.jet.internal.extensionpoints.ModelLoaderExtManager;
import org.eclipse.jet.internal.extensionpoints.PluginProjectMonitor;
import org.eclipse.jet.internal.extensionpoints.WorkspaceTagLibraryManager;
import org.eclipse.jet.internal.extensionpoints.XPathFunctionsManager;
import org.eclipse.jet.internal.runtime.JETBundleInstaller;
import org.eclipse.jet.internal.runtime.JETBundleManager;
import org.eclipse.jet.internal.taglib.InternalTagLibManager;
import org.eclipse.jet.taglib.TagLibrary;
import org.eclipse.jet.transform.IJETBundleManager;
import org.osgi.framework.BundleContext;

public class InternalJET2Platform
extends EMFPlugin.EclipsePlugin {
    private static final IMethodTimer NULL_METHOD_TIMER = new IMethodTimer(){

        public void done() {
        }
    };
    private static boolean DEBUG_STARTUP = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.jet/debug/startup"));
    private static InternalJET2Platform plugin;
    private InternalTagLibManager tagLibManager = null;
    private JETBundleInstaller jetBundleInstaller = null;
    private XPathFunctionsManager xpathFunctionsManager = null;
    private ModelLoaderExtManager modelLoaderExtManager = null;
    private ModelInspectorsManager modelInspectorExtManager = null;
    private JETBundleManager bundleManager = null;
    private PluginProjectMonitor pluginProjectMonitor = null;
    private WorkspaceTagLibraryManager workspaceTagLibraryManager = null;
    private SavedStateManager savedStateManager = null;
    private BundleContext bundleContext;

    public static IMethodTimer getStartupMethodTimer(Class clazz, String methodName) {
        if (DEBUG_STARTUP) {
            return new MethodTimer(clazz, methodName);
        }
        return NULL_METHOD_TIMER;
    }

    public static InternalJET2Platform getDefault() {
        return plugin;
    }

    private static void log(int severity, String msg, Exception e) {
        InternalJET2Platform.getDefault().getLog().log(InternalJET2Platform.newStatus(severity, msg, e));
    }

    public static void log(IStatus result) {
        InternalJET2Platform.getDefault().getLog().log(result);
    }

    public static void logError(String msg) {
        InternalJET2Platform.logError(msg, null);
    }

    public static void logError(String msg, Exception e) {
        InternalJET2Platform.log(4, msg, e);
    }

    public static void logInfo(String msg) {
        InternalJET2Platform.logInfo(msg, null);
    }

    public static void logInfo(String msg, Exception e) {
        InternalJET2Platform.log(1, msg, e);
    }

    public static void logWarning(String msg) {
        InternalJET2Platform.logWarning(msg, null);
    }

    public static void logWarning(String msg, Exception e) {
        InternalJET2Platform.log(2, msg, e);
    }

    public static IStatus newStatus(int severity, String msg, Exception e) {
        return new Status(severity, "org.eclipse.jet", 0, msg == null ? "" : msg, (Throwable)e);
    }

    public InternalJET2Platform() {
        plugin = this;
        JETActivatorWrapper.INSTANCE.setPlugin(this);
    }

    public IPath getCompiledBundleLocation() {
        IPath stateLocation = this.getStateLocation();
        IPath compiledBundleLocation = stateLocation.append("compiledBundles");
        compiledBundleLocation.toFile().mkdirs();
        return compiledBundleLocation;
    }

    public TagLibrary getTagLibrary(String id) {
        this.checkTagLibManager();
        return this.tagLibManager.getTagLibrary(id);
    }

    public TagLibrary getWorkspaceTagLibrary(String id) {
        this.checkWorkspaceTagLibraryManager();
        return this.workspaceTagLibraryManager.getTagLibrary(id);
    }

    public IProject getProjectDefiningTagLibrary(String id) {
        this.checkWorkspaceTagLibraryManager();
        return this.workspaceTagLibraryManager.getProjectDefiningTagLibrary(id);
    }

    public JETBundleInstaller getJETBundleInstaller() {
        this.checkJETBundleInstaller();
        return this.jetBundleInstaller;
    }

    public void start(BundleContext context) throws Exception {
        IMethodTimer timer = InternalJET2Platform.getStartupMethodTimer(((Object)((Object)this)).getClass(), "start(BundleContext)");
        super.start(context);
        this.bundleContext = context;
        this.modelInspectorExtManager = new ModelInspectorsManager();
        this.modelInspectorExtManager.startup();
        this.modelLoaderExtManager = new ModelLoaderExtManager();
        this.modelLoaderExtManager.startup();
        ContextLogEntryFactoryManager.setFactory((IContextLogEntryFactory)new EquinoxContextLogEntryFactory(Platform.getAdapterManager()));
        timer.done();
    }

    private synchronized void checkJETBundleInstaller() {
        if (this.jetBundleInstaller == null) {
            this.jetBundleInstaller = new JETBundleInstaller();
            this.jetBundleInstaller.startup(this.bundleContext);
        }
    }

    private synchronized void checkSavedStateManager() {
        if (this.savedStateManager == null) {
            this.savedStateManager = new SavedStateManager((Plugin)this);
            this.savedStateManager.startup();
        }
    }

    private synchronized void checkWorkspaceTagLibraryManager() {
        if (this.workspaceTagLibraryManager == null) {
            this.pluginProjectMonitor = new PluginProjectMonitor();
            this.workspaceTagLibraryManager = new WorkspaceTagLibraryManager();
            this.workspaceTagLibraryManager.startup(this.pluginProjectMonitor);
            this.pluginProjectMonitor.startup();
        }
    }

    private synchronized void checkBundleManager() {
        if (this.bundleManager == null) {
            this.bundleManager = new JETBundleManager();
            this.bundleManager.startup();
        }
    }

    private synchronized void checkTagLibManager() {
        if (this.tagLibManager == null) {
            this.tagLibManager = new InternalTagLibManager();
            this.tagLibManager.startup();
        }
    }

    private synchronized void checkXPathFunctionManager() {
        if (this.xpathFunctionsManager == null) {
            this.xpathFunctionsManager = new XPathFunctionsManager();
            this.xpathFunctionsManager.startup();
        }
    }

    public synchronized void stop(BundleContext context) throws Exception {
        IMethodTimer timer = InternalJET2Platform.getStartupMethodTimer(((Object)((Object)this)).getClass(), "stop(BundleContext)");
        if (this.tagLibManager != null) {
            this.tagLibManager.shutdown();
            this.tagLibManager = null;
        }
        if (this.jetBundleInstaller != null) {
            this.jetBundleInstaller.shutdown();
            this.jetBundleInstaller = null;
        }
        if (this.xpathFunctionsManager != null) {
            this.xpathFunctionsManager.shutdown();
            this.xpathFunctionsManager = null;
        }
        if (this.modelLoaderExtManager != null) {
            this.modelLoaderExtManager.shutdown();
            this.modelLoaderExtManager = null;
        }
        if (this.modelInspectorExtManager != null) {
            this.modelInspectorExtManager.shutdown();
            this.modelInspectorExtManager = null;
        }
        if (this.bundleManager != null) {
            this.bundleManager.shutdown();
            this.bundleManager = null;
        }
        if (this.workspaceTagLibraryManager != null) {
            this.workspaceTagLibraryManager.shutdown();
            this.workspaceTagLibraryManager = null;
        }
        if (this.pluginProjectMonitor != null) {
            this.pluginProjectMonitor.shutdown();
            this.pluginProjectMonitor = null;
        }
        if (this.savedStateManager != null) {
            this.savedStateManager.shutdown();
            this.savedStateManager = null;
        }
        super.stop(context);
        plugin = null;
        timer.done();
    }

    public static void debugMessage(Object issuer, String message) {
        Class<?> msgClass = null;
        msgClass = issuer instanceof Class ? (Class<?>)issuer : issuer.getClass();
        System.err.println(String.valueOf(msgClass.getName()) + ": " + message);
    }

    public String[] getKnownTagLibraryIds() {
        this.checkTagLibManager();
        return this.tagLibManager.getKnownTagLibraryIds();
    }

    public final XPathFunctionsManager getXPathFunctionsManager() {
        this.checkXPathFunctionManager();
        return this.xpathFunctionsManager;
    }

    public final InternalTagLibManager getTagLibManager() {
        this.checkTagLibManager();
        return this.tagLibManager;
    }

    public final IJETBundleManager getBundleManager() {
        this.checkBundleManager();
        return this.bundleManager;
    }

    public final SavedStateManager getSavedStateManager() {
        this.checkSavedStateManager();
        return this.savedStateManager;
    }

    public static interface IMethodTimer {
        public void done();
    }

    private static class MethodTimer
    implements IMethodTimer {
        private final Class clazz;
        private final String methodName;
        private final long startMilliseconds;

        public MethodTimer(Class clazz, String methodName) {
            this.clazz = clazz;
            this.methodName = methodName;
            this.startMilliseconds = System.currentTimeMillis();
            System.out.println(String.valueOf(clazz.getName()) + "." + methodName + " - entering at " + this.startMilliseconds);
        }

        public void done() {
            long endMillis = System.currentTimeMillis();
            long millis = endMillis - this.startMilliseconds;
            System.out.println(String.valueOf(this.clazz.getName()) + "." + this.methodName + " - exiting at " + endMillis + " - " + millis + "ms");
        }
    }
}

