/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.runtime;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BundleJarInfo {
    private final String jarName;
    private static final String VERSION = "\\d+\\.\\d+\\.\\d+";
    private static final Pattern jarPattern = Pattern.compile("((?:\\w|\\.|\\_)+)_(\\d+\\.\\d+\\.\\d+(?:\\..*)?)(?!\\d+\\.\\d+\\.\\d+).jar");
    private final String symbolicName;
    private final String version;

    public static BundleJarInfo createBundleJarInfo(String jarName) {
        Matcher m = jarPattern.matcher(jarName);
        return m.matches() ? new BundleJarInfo(jarName, m.group(1), m.group(2)) : null;
    }

    private BundleJarInfo(String jarName, String symbolicName, String version) {
        this.jarName = jarName;
        this.symbolicName = symbolicName;
        this.version = version;
    }

    public String getBundleSymbolicName() {
        return this.symbolicName;
    }

    public String getVersion() {
        return this.version;
    }

    public final String getJarName() {
        return this.jarName;
    }
}

