/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib.format;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jet.internal.taglib.format.FormatNowTag;
import org.eclipse.jet.internal.taglib.format.LowerCaseTag;
import org.eclipse.jet.internal.taglib.format.MillisecondsTag;
import org.eclipse.jet.internal.taglib.format.ReplaceAllTag;
import org.eclipse.jet.internal.taglib.format.StripTag;
import org.eclipse.jet.internal.taglib.format.UniqueTag;
import org.eclipse.jet.internal.taglib.format.UpperCaseTag;
import org.eclipse.jet.internal.taglib.format.UuidTag;
import org.eclipse.jet.taglib.CustomTag;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInstanceFactory;

public class TagFactory
implements TagInstanceFactory {
    private final Map tagOrdinalByName = new HashMap(8);

    public TagFactory() {
        this.tagOrdinalByName.put("formatNow", new Integer(1));
        this.tagOrdinalByName.put("lc", new Integer(2));
        this.tagOrdinalByName.put("milliseconds", new Integer(3));
        this.tagOrdinalByName.put("replaceAll", new Integer(4));
        this.tagOrdinalByName.put("strip", new Integer(5));
        this.tagOrdinalByName.put("uc", new Integer(6));
        this.tagOrdinalByName.put("unique", new Integer(7));
        this.tagOrdinalByName.put("uuid", new Integer(8));
    }

    public CustomTag createCustomTag(String name) {
        Integer ordinal = (Integer)this.tagOrdinalByName.get(name);
        switch (ordinal == null ? 0 : ordinal) {
            case 1: {
                return new FormatNowTag();
            }
            case 2: {
                return new LowerCaseTag();
            }
            case 3: {
                return new MillisecondsTag();
            }
            case 4: {
                return new ReplaceAllTag();
            }
            case 5: {
                return new StripTag();
            }
            case 6: {
                return new UpperCaseTag();
            }
            case 7: {
                return new UniqueTag();
            }
            case 8: {
                return new UuidTag();
            }
        }
        throw new JET2TagException("Unknown Tag: " + name);
    }
}

