/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.expression.editor.codeassist;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.xtend.shared.ui.core.builder.XtendXpandNature;
import org.eclipse.xtend.shared.ui.core.builder.XtendXpandNatureUtil;
import org.eclipse.xtend.shared.ui.internal.XtendLog;

public abstract class AbstractExtXptContentAssistProcessor
implements IContentAssistProcessor {
    private IEditorPart editor;

    public AbstractExtXptContentAssistProcessor(IEditorPart editor) {
        this.editor = editor;
    }

    protected IJavaProject getJavaProject() {
        IResource file = (IResource)this.editor.getEditorInput().getAdapter(IResource.class);
        IProject p = file.getProject();
        return JavaCore.create((IProject)p);
    }

    protected IFile getFile() {
        return (IFile)this.editor.getEditorInput().getAdapter(IFile.class);
    }

    public final ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        block6: {
            IProject p = this.getFile().getProject();
            IJavaProject jp = JavaCore.create((IProject)p);
            if (jp == null) {
                return null;
            }
            try {
                if (p.isNatureEnabled(XtendXpandNature.NATURE_ID)) break block6;
                if (MessageDialog.openQuestion((Shell)this.editor.getEditorSite().getShell(), (String)"oAW Nature not configured", (String)("Do you want to add the oAW nature to project '" + p.getName() + "'?"))) {
                    XtendXpandNatureUtil.addExtXptNature(jp);
                    break block6;
                }
                return null;
            }
            catch (CoreException e) {
                XtendLog.logError(e);
            }
        }
        try {
            return this.internalComputeCompletionProposals(viewer, offset);
        }
        catch (Exception e) {
            XtendLog.logError(e);
            return null;
        }
    }

    protected abstract ICompletionProposal[] internalComputeCompletionProposals(ITextViewer var1, int var2);
}

