/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.expression.codeassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.runtime.CommonToken;
import org.eclipse.internal.xtend.expression.codeassist.LazyVar;
import org.eclipse.internal.xtend.expression.codeassist.ProposalComputer;
import org.eclipse.internal.xtend.expression.codeassist.ProposalFactory;
import org.eclipse.internal.xtend.expression.codeassist.ReverseScanner;
import org.eclipse.internal.xtend.expression.codeassist.TypeProposalComputer;
import org.eclipse.internal.xtend.xtend.ast.Extension;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.ExpressionFacade;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.typesystem.Callable;
import org.eclipse.xtend.typesystem.Operation;
import org.eclipse.xtend.typesystem.ParameterizedType;
import org.eclipse.xtend.typesystem.Property;
import org.eclipse.xtend.typesystem.StaticProperty;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionProposalComputer
implements ProposalComputer {
    private static final Set<String> operators = new HashSet<String>();
    private static final Set<String> stopper;
    private static final Set<String> methodNames;
    private static final Set<String> operands;
    private static final Map<String, String> blockTokens;
    private static final Pattern QUALIFIED_NAME;
    private static final Pattern COL_OP;
    private static final Pattern LET;

    static {
        operators.add("&&");
        operators.add("/");
        operators.add(".");
        operators.add("==");
        operators.add(">=");
        operators.add(">");
        operators.add("<=");
        operators.add("<");
        operators.add("-");
        operators.add("%");
        operators.add("*");
        operators.add("!=");
        operators.add("!");
        operators.add("||");
        operators.add("+");
        stopper = new HashSet<String>();
        stopper.add("(");
        stopper.add(":");
        stopper.add("?");
        stopper.add("|");
        stopper.add("{");
        stopper.add(",");
        methodNames = new HashSet<String>();
        methodNames.add("collect");
        methodNames.add("exists");
        methodNames.add("notExists");
        methodNames.add("forAll");
        methodNames.add("reject");
        methodNames.add("select");
        methodNames.add("selectFirst");
        methodNames.add("sortBy");
        methodNames.add("typeSelect");
        operands = new HashSet<String>();
        operands.add("collect");
        operands.add("exists");
        operands.add("notExists");
        operands.add("false");
        operands.add("forAll");
        operands.add("null");
        operands.add("reject");
        operands.add("select");
        operands.add("sortBy");
        operands.add("selectFirst");
        operands.add("true");
        operands.add("typeSelect");
        blockTokens = new HashMap<String, String>();
        blockTokens.put("(", ")");
        blockTokens.put("{", "}");
        QUALIFIED_NAME = Pattern.compile("\\W*(.*)(?:::\\w*)$");
        COL_OP = Pattern.compile("((select|collect|exists|notExists|reject|forEach|sortBy)\\s*\\(\\s*(\\w+)\\s*\\|)|(\\()|(\\))");
        LET = Pattern.compile(".*let\\s*(\\w+)\\s*=\\s*([^:]+):([^:]*)");
    }

    @Override
    public List<Object> computeProposals(String txt, ExecutionContext ctx, ProposalFactory factory) {
        HashSet<AnalysationIssue> issues;
        String[] s = ExpressionProposalComputer.computePrefixAndTargetExpression(txt);
        String prefix = s[0];
        String expressionString = s[1];
        ctx = ExpressionProposalComputer.computeExecutionContext(txt, ctx);
        ArrayList<Object> proposals = new ArrayList<Object>();
        if (prefix.length() > 0 && expressionString == null) {
            proposals.addAll(new TypeProposalComputer().computeProposals(txt, ctx, factory));
        }
        Type implicitVariableType = null;
        if (expressionString != null && (implicitVariableType = new ExpressionFacade(ctx).analyze(expressionString, issues = new HashSet<AnalysationIssue>())) == null) {
            return Collections.emptyList();
        }
        if (implicitVariableType == null) {
            String typeName;
            Map<String, Variable> vars = ctx.getVisibleVariables();
            for (String string : vars.keySet()) {
                if (!string.toLowerCase().startsWith(prefix.toLowerCase())) continue;
                Object object = ctx.getVariable(string).getValue();
                proposals.add(factory.createVariableProposal(string, (Type)object, prefix));
            }
            Variable implicitVariable = ctx.getVariable("this");
            if (implicitVariable != null) {
                implicitVariableType = (Type)implicitVariable.getValue();
                proposals.addAll(ExpressionProposalComputer.getAllMemberProposals(implicitVariableType, prefix, ctx, factory));
                for (StaticProperty staticProperty : implicitVariableType.getAllStaticProperties()) {
                    if (!staticProperty.getName().startsWith(prefix)) continue;
                    proposals.add(factory.createStaticPropertyProposal(staticProperty, prefix, false));
                }
            }
            Set<? extends Extension> set = ctx.getAllExtensions();
            for (Extension extension : set) {
                if (!extension.getName().toLowerCase().startsWith(prefix.toLowerCase())) continue;
                boolean bl = false;
                if (extension.getParameterTypes().size() >= 1) {
                    Type firstParameterType = extension.getParameterTypes().get(0);
                    if (implicitVariable != null && ((implicitVariableType = (Type)implicitVariable.getValue()).isAssignableFrom(firstParameterType) || firstParameterType.isAssignableFrom(implicitVariableType))) {
                        bl = true;
                        System.out.println("SKIP");
                    }
                }
                if (bl) continue;
                System.out.println("NOSKIP");
                proposals.add(factory.createExtensionProposal(extension, prefix));
            }
            Matcher matcher = QUALIFIED_NAME.matcher(txt);
            if (matcher.matches() && (implicitVariableType = ctx.getTypeForName(typeName = matcher.group(1))) != null) {
                for (StaticProperty staticProperty : implicitVariableType.getAllStaticProperties()) {
                    if (!staticProperty.getName().startsWith(prefix)) continue;
                    proposals.add(factory.createStaticPropertyProposal(staticProperty, prefix, false));
                }
            }
        } else {
            proposals.addAll(ExpressionProposalComputer.getAllMemberProposals(implicitVariableType, prefix, ctx, factory));
        }
        return proposals;
    }

    public static final ExecutionContext computeExecutionContext(String txt, ExecutionContext ctx) {
        Stack<LazyVar> vars = new Stack<LazyVar>();
        Matcher m = LET.matcher(txt);
        while (m.find()) {
            LazyVar v = new LazyVar();
            v.name = m.group(1);
            v.forEach = false;
            v.expression = m.group(2).trim();
            vars.push(v);
        }
        m = COL_OP.matcher(txt);
        while (m.find()) {
            if (m.group(1) != null) {
                String[] s = ExpressionProposalComputer.computePrefixAndTargetExpression(txt.substring(0, m.start()));
                String expressionString = s[1];
                LazyVar v = new LazyVar();
                v.name = m.group(3);
                v.forEach = true;
                v.expression = expressionString;
                vars.push(v);
                continue;
            }
            if (m.group(4) != null) {
                vars.push(null);
                continue;
            }
            if (m.group(5) != null) {
                vars.pop();
                continue;
            }
            throw new IllegalStateException("Match:" + m.group());
        }
        for (LazyVar v : vars) {
            if (v == null) continue;
            Type targetType = null;
            String expressionString = v.expression;
            if (expressionString == null) {
                Variable var = ctx.getVariable("this");
                if (var != null && var.getValue() instanceof ParameterizedType) {
                    targetType = ((ParameterizedType)var.getValue()).getInnerType();
                }
            } else {
                targetType = new ExpressionFacade(ctx).analyze(expressionString, new HashSet<AnalysationIssue>());
                if (v.forEach) {
                    targetType = targetType instanceof ParameterizedType ? ((ParameterizedType)targetType).getInnerType() : null;
                }
            }
            if (targetType == null) continue;
            ctx = ctx.cloneWithVariable(new Variable(v.name, targetType));
        }
        return ctx;
    }

    private static final List<Object> getAllMemberProposals(Type targetType, String prefix, ExecutionContext ctx, ProposalFactory factory) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (targetType != null) {
            Set<? extends Callable> s = targetType.getAllFeatures();
            for (Callable callable : s) {
                if (!callable.getName().toLowerCase().startsWith(prefix.toLowerCase())) continue;
                if (callable instanceof Property) {
                    result.add(factory.createPropertyProposal((Property)callable, prefix, false));
                    continue;
                }
                if (!(callable instanceof Operation) || !Character.isJavaIdentifierStart(callable.getName().charAt(0))) continue;
                result.add(factory.createOperationProposal((Operation)callable, prefix, false));
            }
            Set<? extends Extension> set = ctx.getAllExtensions();
            for (Extension extension : set) {
                Type firstParameterType;
                if (!extension.getName().toLowerCase().startsWith(prefix.toLowerCase()) || extension.getParameterTypes().size() < 1 || !targetType.equals(firstParameterType = extension.getParameterTypes().get(0))) continue;
                result.add(factory.createExtensionOnMemberPositionProposal(extension, prefix, false));
            }
            if (targetType instanceof ParameterizedType) {
                result.addAll(ExpressionProposalComputer.getAllCollectionOperations(prefix, factory));
                targetType = ((ParameterizedType)targetType).getInnerType();
                s = targetType.getAllFeatures();
                for (Callable callable : s) {
                    if (!callable.getName().toLowerCase().startsWith(prefix.toLowerCase())) continue;
                    if (callable instanceof Property) {
                        result.add(factory.createPropertyProposal((Property)callable, prefix, true));
                        continue;
                    }
                    if (!(callable instanceof Operation) || !Character.isJavaIdentifierStart(callable.getName().charAt(0))) continue;
                    result.add(factory.createOperationProposal((Operation)callable, prefix, true));
                }
                Set<? extends Extension> set2 = ctx.getAllExtensions();
                for (Extension extension : set2) {
                    if (!extension.getName().toLowerCase().startsWith(prefix.toLowerCase()) || extension.getParameterTypes().size() < 1 || !extension.getParameterTypes().get(0).isAssignableFrom(targetType)) continue;
                    result.add(factory.createExtensionOnMemberPositionProposal(extension, prefix, true));
                }
            }
        }
        return result;
    }

    private static List<Object> getAllCollectionOperations(String prefix, ProposalFactory f) {
        ArrayList<Object> result = new ArrayList<Object>();
        String s = "select(e|expression-with-e)";
        if (s.startsWith(prefix)) {
            result.add(f.createCollectionSpecificOperationProposal(s, s, prefix, s.indexOf("expression-with-e"), "expression-with-e".length()));
        }
        if ((s = "reject(e|expression-with-e)").startsWith(prefix)) {
            result.add(f.createCollectionSpecificOperationProposal(s, s, prefix, s.indexOf("expression-with-e"), "expression-with-e".length()));
        }
        if ((s = "selectFirst(e|expression-with-e)").startsWith(prefix)) {
            result.add(f.createCollectionSpecificOperationProposal(s, s, prefix, s.indexOf("expression-with-e"), "expression-with-e".length()));
        }
        if ((s = "collect(e|expression-with-e)").startsWith(prefix)) {
            result.add(f.createCollectionSpecificOperationProposal(s, s, prefix, s.indexOf("expression-with-e"), "expression-with-e".length()));
        }
        if ((s = "exists(e|expression-with-e)").startsWith(prefix)) {
            result.add(f.createCollectionSpecificOperationProposal(s, s, prefix, s.indexOf("expression-with-e"), "expression-with-e".length()));
        }
        if ((s = "notExists(e|expression-with-e)").startsWith(prefix)) {
            result.add(f.createCollectionSpecificOperationProposal(s, s, prefix, s.indexOf("expression-with-e"), "expression-with-e".length()));
        }
        if ((s = "forAll(e|expression-with-e)").startsWith(prefix)) {
            result.add(f.createCollectionSpecificOperationProposal(s, s, prefix, s.indexOf("expression-with-e"), "expression-with-e".length()));
        }
        if ((s = "sortBy(e|expression-with-e)").startsWith(prefix)) {
            result.add(f.createCollectionSpecificOperationProposal(s, s, prefix, s.indexOf("expression-with-e"), "expression-with-e".length()));
        }
        if ((s = "typeSelect(Type)").startsWith(prefix)) {
            result.add(f.createCollectionSpecificOperationProposal(s, s, prefix, s.indexOf("Type"), "Type".length()));
        }
        return result;
    }

    public static final String[] computePrefixAndTargetExpression(String str) {
        ReverseScanner scanner = new ReverseScanner(str);
        String prefix = "";
        Object expr = null;
        try {
            CommonToken t = scanner.previousToken();
            if (t != null) {
                if (!Character.isWhitespace(str.charAt(str.length() - 1)) && Character.isJavaIdentifierStart(t.getText().charAt(0))) {
                    prefix = t.getText();
                    t = scanner.previousToken();
                }
                int exprEnd = scanner.getOffset();
                if (t != null && ".".equals(t.getText())) {
                    boolean lastWasOperator = true;
                    boolean stop = false;
                    while (!stop && (t = scanner.previousToken()) != null) {
                        if (ExpressionProposalComputer.isOperand(t)) {
                            if (lastWasOperator) {
                                lastWasOperator = false;
                                continue;
                            }
                            scanner.nextToken();
                            stop = true;
                            continue;
                        }
                        if (".".equals(t.getText())) {
                            if (!lastWasOperator) {
                                lastWasOperator = true;
                                continue;
                            }
                            return new String[]{prefix, expr};
                        }
                        if (ExpressionProposalComputer.isBlockCloser(t) && lastWasOperator) {
                            CommonToken previousToken;
                            lastWasOperator = false;
                            Stack<CommonToken> s = new Stack<CommonToken>();
                            s.push(t);
                            while (!s.isEmpty()) {
                                CommonToken temp = scanner.previousToken();
                                if (temp == null) {
                                    return new String[]{prefix, expr};
                                }
                                if (temp.getType() == t.getType()) {
                                    s.push(temp);
                                    continue;
                                }
                                if (!ExpressionProposalComputer.isOpposite(temp, t)) continue;
                                s.pop();
                            }
                            if (!")".equals(t.getText()) || ExpressionProposalComputer.isMethodName(previousToken = scanner.previousToken())) continue;
                            scanner.nextToken();
                            continue;
                        }
                        scanner.nextToken();
                        stop = true;
                    }
                    return new String[]{prefix, str.substring(scanner.getOffset(), exprEnd).trim()};
                }
            }
            return new String[]{prefix, expr};
        }
        catch (Exception exception) {
            return new String[]{prefix, expr};
        }
    }

    private static final boolean isMethodName(CommonToken token) {
        if (token != null) {
            return token.getType() == 6 || methodNames.contains(token.getText());
        }
        return false;
    }

    private static final boolean isOpposite(CommonToken left, CommonToken right) {
        String temp = blockTokens.get(left.getText());
        if (temp == null) {
            return false;
        }
        return temp != null && right.getText().equals(temp);
    }

    private static final boolean isBlockCloser(CommonToken t) {
        return blockTokens.values().contains(t.getText());
    }

    private static final boolean isOperand(CommonToken t) {
        return t.getType() == 6 || t.getType() == 5 || t.getType() == 4 || operands.contains(t.getText());
    }
}

