/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.xtend.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.internal.xtend.expression.ast.DeclaredParameter;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.internal.xtend.xtend.ast.Extension;
import org.eclipse.internal.xtend.xtend.ast.ExtensionFile;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.EvaluationException;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExtension
extends SyntaxElement
implements Extension {
    private Identifier name;
    private List<DeclaredParameter> formalParameters;
    protected ExtensionFile file;
    protected boolean cached = false;
    private boolean isPrivate = false;
    private final Map<List<Object>, Object> cache = new HashMap<List<Object>, Object>();
    private List<Type> parameterTypes = null;
    protected Identifier returnType;
    private String _stringRepresentation = null;
    private String _outlineRepresentation = null;

    public AbstractExtension(Identifier name, Identifier returnType, List<DeclaredParameter> formalParameters, boolean cached, boolean isPrivate) {
        this.name = name;
        this.formalParameters = formalParameters;
        this.returnType = returnType;
        this.cached = cached;
        this.isPrivate = isPrivate;
    }

    @Override
    public List<DeclaredParameter> getFormalParameters() {
        return this.formalParameters;
    }

    @Override
    public String getName() {
        return this.name.getValue();
    }

    public Identifier getNameIdentifier() {
        return this.name;
    }

    @Override
    public final Type getReturnType(Type[] parameters, ExecutionContext ctx, Set<AnalysationIssue> issues) {
        ctx = ctx.cloneWithResource(this.getExtensionFile());
        return this.internalGetReturnType(parameters, ctx, issues);
    }

    protected abstract Type internalGetReturnType(Type[] var1, ExecutionContext var2, Set<AnalysationIssue> var3);

    @Override
    public final void analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        Type pt;
        List<DeclaredParameter> params = this.getFormalParameters();
        HashSet<String> usedNames = new HashSet<String>();
        for (DeclaredParameter p : params) {
            Type pt2 = ctx.getTypeForName(p.getType().getValue());
            if (pt2 == null) {
                issues.add(new AnalysationIssue(AnalysationIssue.TYPE_NOT_FOUND, "Type not found: " + p.getType().getValue(), p.getType()));
            }
            if (!usedNames.add(p.getName().getValue())) {
                issues.add(new AnalysationIssue(AnalysationIssue.SYNTAX_ERROR, "Duplicate parameter name: " + p.getName().getValue(), p.getName()));
            }
            ctx = ctx.cloneWithVariable(new Variable(p.getName().getValue(), pt2));
        }
        if (this.returnType != null && (pt = ctx.getTypeForName(this.returnType.getValue())) == null) {
            issues.add(new AnalysationIssue(AnalysationIssue.TYPE_NOT_FOUND, "Type not found: " + this.returnType.getValue(), this.returnType));
        }
        try {
            this.analyzeInternal(ctx, issues);
        }
        catch (RuntimeException ex) {
            ctx.handleRuntimeException(ex, this, null);
        }
    }

    protected abstract void analyzeInternal(ExecutionContext var1, Set<AnalysationIssue> var2);

    @Override
    public Object evaluate(Object[] parameters, ExecutionContext ctx) {
        try {
            List<Object> l;
            if (this.cached && this.cache.containsKey(l = Arrays.asList(parameters))) {
                return this.cache.get(l);
            }
            if (this.getExtensionFile() == null) {
                throw new IllegalStateException("No containing file!");
            }
            ctx = ctx.cloneWithResource(this.getExtensionFile());
            Object result = this.evaluateInternal(parameters, ctx);
            if (this.cached) {
                this.cache.put(Arrays.asList(parameters), result);
            }
            return result;
        }
        catch (RuntimeException ex) {
            ctx.handleRuntimeException(ex, this, null);
            return null;
        }
    }

    @Override
    public final void setExtensionFile(ExtensionFile f) {
        this.file = f;
    }

    @Override
    public ExtensionFile getExtensionFile() {
        return this.file;
    }

    protected abstract Object evaluateInternal(Object[] var1, ExecutionContext var2);

    @Override
    public List<String> getParameterNames() {
        ArrayList<String> names = new ArrayList<String>();
        Iterator<DeclaredParameter> iter = this.getFormalParameters().iterator();
        while (iter.hasNext()) {
            names.add(iter.next().getName().getValue());
        }
        return names;
    }

    @Override
    public void init(ExecutionContext ctx) {
        if (this.parameterTypes == null) {
            try {
                this.parameterTypes = new ArrayList<Type>();
                Iterator<DeclaredParameter> iter = this.getFormalParameters().iterator();
                while (iter.hasNext()) {
                    String name = iter.next().getType().getValue();
                    Type t = ctx.getTypeForName(name);
                    if (t == null) {
                        throw new EvaluationException("Couldn't resolve type for '" + name + "'. Did you forget to configure the corresponding metamodel?", (SyntaxElement)this, ctx);
                    }
                    this.parameterTypes.add(t);
                }
            }
            catch (RuntimeException e) {
                this.parameterTypes = null;
                throw e;
            }
        }
    }

    @Override
    public Type getReturnType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Type> getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public Identifier getReturnTypeIdentifier() {
        return this.returnType;
    }

    @Override
    public String toString() {
        if (this._stringRepresentation == null) {
            this._stringRepresentation = String.valueOf(this.returnType != null ? String.valueOf(this.returnType.getValue()) + " " : "") + this.getName() + "(" + this.paramsToString() + ")";
        }
        return this._stringRepresentation;
    }

    @Override
    public String toOutlineString() {
        if (this._outlineRepresentation == null) {
            this._outlineRepresentation = String.valueOf(this.getName()) + "(" + this.paramsToOutlineString() + ")" + (this.returnType != null ? ": " + this.returnType.getValue() : "");
        }
        return this._outlineRepresentation;
    }

    private String paramsToString() {
        StringBuffer buff = new StringBuffer();
        Iterator<DeclaredParameter> iter = this.getFormalParameters().iterator();
        while (iter.hasNext()) {
            DeclaredParameter element = iter.next();
            buff.append(element.getType() + " " + element.getName());
            if (!iter.hasNext()) continue;
            buff.append(",");
        }
        return buff.toString();
    }

    private String paramsToOutlineString() {
        StringBuffer buff = new StringBuffer();
        Iterator<DeclaredParameter> iter = this.getFormalParameters().iterator();
        while (iter.hasNext()) {
            DeclaredParameter element = iter.next();
            buff.append(element.getName());
            if (!iter.hasNext()) continue;
            buff.append(", ");
        }
        return buff.toString();
    }

    @Override
    public boolean isPrivate() {
        return this.isPrivate;
    }

    @Override
    public boolean isCached() {
        return this.cached;
    }

    @Override
    public String getQualifiedName() {
        return String.valueOf(this.getExtensionFile().getFullyQualifiedName()) + "::" + this.getName();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 31 * result + (this.parameterTypes == null ? 0 : this.parameterTypes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractExtension other = (AbstractExtension)obj;
        if (this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName())) {
            return false;
        }
        return !(this.parameterTypes == null ? other.parameterTypes != null : !this.parameterTypes.equals(other.parameterTypes));
    }
}

