/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.visualization.google.internal;

import java.io.IOException;
import org.eclipse.rap.rwt.Adaptable;
import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.visualization.google.VisualizationWidget;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public abstract class VisualizationWidgetLCA
extends AbstractWidgetLCA {
    protected static final String REDRAW_FUNC = "redraw";
    protected static final String PROP_DATA = "widgetData";
    protected static final String PROP_OPTIONS = "widgetOptions";
    private static final String[] ALLOWED_STYLES = new String[]{"BORDER"};

    public abstract Class getWidgetType();

    public void renderInitialization(Widget widget) throws IOException {
        Control control = (Control)widget;
        IClientObject clientObject = ClientObjectFactory.getClientObject((Adaptable)control);
        clientObject.create(this.getWidgetType().getCanonicalName());
        clientObject.set("parent", WidgetUtil.getId((Widget)control.getParent()));
        clientObject.set("style", (Object)WidgetLCAUtil.getStyles((Widget)control, (String[])ALLOWED_STYLES));
    }

    public void preserveValues(Widget widget) {
        ControlLCAUtil.preserveValues((Control)((Control)widget));
        WidgetLCAUtil.preserveCustomVariant((Widget)widget);
        ControlLCAUtil.preserveValues((Control)((Control)widget));
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)widget);
        adapter.preserve(PROP_OPTIONS, (Object)((VisualizationWidget)widget).getWidgetOptions());
        adapter.preserve(PROP_DATA, (Object)((VisualizationWidget)widget).getWidgetData());
    }

    public void renderChanges(Widget widget) throws IOException {
        boolean changed;
        ControlLCAUtil.renderChanges((Control)((Control)widget));
        WidgetLCAUtil.renderCustomVariant((Widget)widget);
        VisualizationWidget vWidget = (VisualizationWidget)widget;
        IClientObject clientObject = ClientObjectFactory.getClientObject((Adaptable)vWidget);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)widget);
        boolean bl = changed = !adapter.isInitialized() || WidgetLCAUtil.hasChanged((Widget)widget, (String)PROP_OPTIONS, (Object)vWidget.getWidgetOptions());
        if (changed) {
            clientObject.set(PROP_OPTIONS, vWidget.getWidgetOptions());
        }
        if (changed = WidgetLCAUtil.hasChanged((Widget)widget, (String)PROP_DATA, (Object)vWidget.getWidgetData())) {
            clientObject.set(PROP_DATA, vWidget.getWidgetData());
        }
        if (vWidget.isDirty()) {
            clientObject.call(REDRAW_FUNC, null);
            vWidget.setDirty(false);
        }
    }

    public void renderDispose(Widget widget) throws IOException {
        ClientObjectFactory.getClientObject((Adaptable)widget).destroy();
    }

    public void readData(Widget widget) {
        if (widget == null) {
            return;
        }
        VisualizationWidget visWidget = (VisualizationWidget)widget;
        String selectedItem = WidgetLCAUtil.readPropertyValue((Widget)visWidget, (String)"selectedItem");
        String selectedRow = WidgetLCAUtil.readPropertyValue((Widget)visWidget, (String)"selectedRow");
        String selectedColumn = WidgetLCAUtil.readPropertyValue((Widget)visWidget, (String)"selectedColumn");
        String selectedValue = WidgetLCAUtil.readPropertyValue((Widget)visWidget, (String)"selectedValue");
        if (selectedItem != null) {
            visWidget.setSelectedItem(selectedItem);
            visWidget.setSelectedRow(selectedRow);
            visWidget.setSelectedColumn(selectedColumn);
            visWidget.setSelectedValue(selectedValue);
            ControlLCAUtil.processSelection((Widget)visWidget, null, (boolean)true);
        }
    }
}

