/**
 * Copyright (c) 2022 DB Netz AG and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 */
package org.eclipse.set.toolboxmodel.Gleis.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.set.toolboxmodel.Gleis.util.GleisAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class GleisItemProviderAdapterFactory extends GleisAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GleisItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Gleis.Baubereich_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Baubereich_Art_TypeClassItemProvider baubereich_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Gleis.Baubereich_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBaubereich_Art_TypeClassAdapter() {
		if (baubereich_Art_TypeClassItemProvider == null) {
			baubereich_Art_TypeClassItemProvider = new Baubereich_Art_TypeClassItemProvider(this);
		}

		return baubereich_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Gleis.Bez_Gleis_Bezeichnung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bez_Gleis_Bezeichnung_TypeClassItemProvider bez_Gleis_Bezeichnung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Gleis.Bez_Gleis_Bezeichnung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBez_Gleis_Bezeichnung_TypeClassAdapter() {
		if (bez_Gleis_Bezeichnung_TypeClassItemProvider == null) {
			bez_Gleis_Bezeichnung_TypeClassItemProvider = new Bez_Gleis_Bezeichnung_TypeClassItemProvider(this);
		}

		return bez_Gleis_Bezeichnung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Gleis.Fahrstrom_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fahrstrom_TypeClassItemProvider fahrstrom_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Gleis.Fahrstrom_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFahrstrom_TypeClassAdapter() {
		if (fahrstrom_TypeClassItemProvider == null) {
			fahrstrom_TypeClassItemProvider = new Fahrstrom_TypeClassItemProvider(this);
		}

		return fahrstrom_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Gleis.Geschwindigkeit_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Geschwindigkeit_TypeClassItemProvider geschwindigkeit_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Gleis.Geschwindigkeit_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGeschwindigkeit_TypeClassAdapter() {
		if (geschwindigkeit_TypeClassItemProvider == null) {
			geschwindigkeit_TypeClassItemProvider = new Geschwindigkeit_TypeClassItemProvider(this);
		}

		return geschwindigkeit_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Gleis.Gleis_Abschnitt} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Gleis_AbschnittItemProvider gleis_AbschnittItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Gleis.Gleis_Abschnitt}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGleis_AbschnittAdapter() {
		if (gleis_AbschnittItemProvider == null) {
			gleis_AbschnittItemProvider = new Gleis_AbschnittItemProvider(this);
		}

		return gleis_AbschnittItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Gleis.Gleis_Art} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Gleis_ArtItemProvider gleis_ArtItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Gleis.Gleis_Art}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGleis_ArtAdapter() {
		if (gleis_ArtItemProvider == null) {
			gleis_ArtItemProvider = new Gleis_ArtItemProvider(this);
		}

		return gleis_ArtItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Gleis.Gleis_Baubereich} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Gleis_BaubereichItemProvider gleis_BaubereichItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Gleis.Gleis_Baubereich}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGleis_BaubereichAdapter() {
		if (gleis_BaubereichItemProvider == null) {
			gleis_BaubereichItemProvider = new Gleis_BaubereichItemProvider(this);
		}

		return gleis_BaubereichItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Gleis.Gleis_Bezeichnung} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Gleis_BezeichnungItemProvider gleis_BezeichnungItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Gleis.Gleis_Bezeichnung}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGleis_BezeichnungAdapter() {
		if (gleis_BezeichnungItemProvider == null) {
			gleis_BezeichnungItemProvider = new Gleis_BezeichnungItemProvider(this);
		}

		return gleis_BezeichnungItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Gleis.Gleis_Bezeichnung_Bezeichnung_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Gleis_Bezeichnung_Bezeichnung_AttributeGroupItemProvider gleis_Bezeichnung_Bezeichnung_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Gleis.Gleis_Bezeichnung_Bezeichnung_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGleis_Bezeichnung_Bezeichnung_AttributeGroupAdapter() {
		if (gleis_Bezeichnung_Bezeichnung_AttributeGroupItemProvider == null) {
			gleis_Bezeichnung_Bezeichnung_AttributeGroupItemProvider = new Gleis_Bezeichnung_Bezeichnung_AttributeGroupItemProvider(this);
		}

		return gleis_Bezeichnung_Bezeichnung_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Gleis.Gleis_Fahrbahn} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Gleis_FahrbahnItemProvider gleis_FahrbahnItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Gleis.Gleis_Fahrbahn}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGleis_FahrbahnAdapter() {
		if (gleis_FahrbahnItemProvider == null) {
			gleis_FahrbahnItemProvider = new Gleis_FahrbahnItemProvider(this);
		}

		return gleis_FahrbahnItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Gleis.Gleis_Lichtraum} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Gleis_LichtraumItemProvider gleis_LichtraumItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Gleis.Gleis_Lichtraum}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGleis_LichtraumAdapter() {
		if (gleis_LichtraumItemProvider == null) {
			gleis_LichtraumItemProvider = new Gleis_LichtraumItemProvider(this);
		}

		return gleis_LichtraumItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Gleis.Gleis_Schaltgruppe} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Gleis_SchaltgruppeItemProvider gleis_SchaltgruppeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Gleis.Gleis_Schaltgruppe}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGleis_SchaltgruppeAdapter() {
		if (gleis_SchaltgruppeItemProvider == null) {
			gleis_SchaltgruppeItemProvider = new Gleis_SchaltgruppeItemProvider(this);
		}

		return gleis_SchaltgruppeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Gleis.Gleisart_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Gleisart_TypeClassItemProvider gleisart_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Gleis.Gleisart_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGleisart_TypeClassAdapter() {
		if (gleisart_TypeClassItemProvider == null) {
			gleisart_TypeClassItemProvider = new Gleisart_TypeClassItemProvider(this);
		}

		return gleisart_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Gleis.Konstruktion_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Konstruktion_TypeClassItemProvider konstruktion_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Gleis.Konstruktion_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createKonstruktion_TypeClassAdapter() {
		if (konstruktion_TypeClassItemProvider == null) {
			konstruktion_TypeClassItemProvider = new Konstruktion_TypeClassItemProvider(this);
		}

		return konstruktion_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Gleis.Lichtraumprofil_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Lichtraumprofil_TypeClassItemProvider lichtraumprofil_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Gleis.Lichtraumprofil_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLichtraumprofil_TypeClassAdapter() {
		if (lichtraumprofil_TypeClassItemProvider == null) {
			lichtraumprofil_TypeClassItemProvider = new Lichtraumprofil_TypeClassItemProvider(this);
		}

		return lichtraumprofil_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Gleis.Nutzung_Gueterzug_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Nutzung_Gueterzug_TypeClassItemProvider nutzung_Gueterzug_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Gleis.Nutzung_Gueterzug_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNutzung_Gueterzug_TypeClassAdapter() {
		if (nutzung_Gueterzug_TypeClassItemProvider == null) {
			nutzung_Gueterzug_TypeClassItemProvider = new Nutzung_Gueterzug_TypeClassItemProvider(this);
		}

		return nutzung_Gueterzug_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Gleis.Nutzung_Rangier_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Nutzung_Rangier_TypeClassItemProvider nutzung_Rangier_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Gleis.Nutzung_Rangier_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNutzung_Rangier_TypeClassAdapter() {
		if (nutzung_Rangier_TypeClassItemProvider == null) {
			nutzung_Rangier_TypeClassItemProvider = new Nutzung_Rangier_TypeClassItemProvider(this);
		}

		return nutzung_Rangier_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Gleis.Nutzung_Reisezug_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Nutzung_Reisezug_TypeClassItemProvider nutzung_Reisezug_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Gleis.Nutzung_Reisezug_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNutzung_Reisezug_TypeClassAdapter() {
		if (nutzung_Reisezug_TypeClassItemProvider == null) {
			nutzung_Reisezug_TypeClassItemProvider = new Nutzung_Reisezug_TypeClassItemProvider(this);
		}

		return nutzung_Reisezug_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Gleis.Nutzung_SBahn_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Nutzung_SBahn_TypeClassItemProvider nutzung_SBahn_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Gleis.Nutzung_SBahn_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNutzung_SBahn_TypeClassAdapter() {
		if (nutzung_SBahn_TypeClassItemProvider == null) {
			nutzung_SBahn_TypeClassItemProvider = new Nutzung_SBahn_TypeClassItemProvider(this);
		}

		return nutzung_SBahn_TypeClassItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose() {
		if (baubereich_Art_TypeClassItemProvider != null) baubereich_Art_TypeClassItemProvider.dispose();
		if (bez_Gleis_Bezeichnung_TypeClassItemProvider != null) bez_Gleis_Bezeichnung_TypeClassItemProvider.dispose();
		if (fahrstrom_TypeClassItemProvider != null) fahrstrom_TypeClassItemProvider.dispose();
		if (geschwindigkeit_TypeClassItemProvider != null) geschwindigkeit_TypeClassItemProvider.dispose();
		if (gleis_AbschnittItemProvider != null) gleis_AbschnittItemProvider.dispose();
		if (gleis_ArtItemProvider != null) gleis_ArtItemProvider.dispose();
		if (gleis_BaubereichItemProvider != null) gleis_BaubereichItemProvider.dispose();
		if (gleis_BezeichnungItemProvider != null) gleis_BezeichnungItemProvider.dispose();
		if (gleis_Bezeichnung_Bezeichnung_AttributeGroupItemProvider != null) gleis_Bezeichnung_Bezeichnung_AttributeGroupItemProvider.dispose();
		if (gleis_FahrbahnItemProvider != null) gleis_FahrbahnItemProvider.dispose();
		if (gleis_LichtraumItemProvider != null) gleis_LichtraumItemProvider.dispose();
		if (gleis_SchaltgruppeItemProvider != null) gleis_SchaltgruppeItemProvider.dispose();
		if (gleisart_TypeClassItemProvider != null) gleisart_TypeClassItemProvider.dispose();
		if (konstruktion_TypeClassItemProvider != null) konstruktion_TypeClassItemProvider.dispose();
		if (lichtraumprofil_TypeClassItemProvider != null) lichtraumprofil_TypeClassItemProvider.dispose();
		if (nutzung_Gueterzug_TypeClassItemProvider != null) nutzung_Gueterzug_TypeClassItemProvider.dispose();
		if (nutzung_Rangier_TypeClassItemProvider != null) nutzung_Rangier_TypeClassItemProvider.dispose();
		if (nutzung_Reisezug_TypeClassItemProvider != null) nutzung_Reisezug_TypeClassItemProvider.dispose();
		if (nutzung_SBahn_TypeClassItemProvider != null) nutzung_SBahn_TypeClassItemProvider.dispose();
	}

}
