/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.core.tests.segmentstore.statistics;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.statistics.ITreeStatistics;
import org.eclipse.tracecompass.analysis.timing.core.statistics.ITreeStatisticsAnalysis;
import org.eclipse.tracecompass.analysis.timing.core.statistics.TreeStatistics;
import org.eclipse.tracecompass.segmentstore.core.BasicSegment;
import org.eclipse.tracecompass.segmentstore.core.ISegment;

public class StubTreeStatisticsAnalysis
implements ITreeStatisticsAnalysis<ISegment> {
    private final ITreeStatistics<@NonNull ISegment> fStatsRoot = StubTreeStatisticsAnalysis.createTreeStatistics("Total");
    private final ITreeStatistics<@NonNull ISegment> fStatsSelection = StubTreeStatisticsAnalysis.createTreeStatistics("Selection");

    public @Nullable ITreeStatistics<@NonNull ISegment> getStatsRoot() {
        return this.fStatsRoot;
    }

    public @Nullable ITreeStatistics<@NonNull ISegment> getStatsRootForRange(long start, long end, @NonNull IProgressMonitor monitor) {
        return this.fStatsSelection;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static ITreeStatistics<@NonNull ISegment> createTreeStatistics(@NonNull String rootName) {
        @NonNull TreeStatistics rootStats = new TreeStatistics(ISegment::getLength, rootName);
        StubTreeStatisticsAnalysis.updateStatistic((TreeStatistics<ISegment>)rootStats, 1000);
        @NonNull TreeStatistics chlid1Stats = new TreeStatistics(ISegment::getLength, "child1");
        StubTreeStatisticsAnalysis.updateStatistic((TreeStatistics<ISegment>)chlid1Stats, 2000);
        @NonNull TreeStatistics chlid2Stats = new TreeStatistics(ISegment::getLength, "child2");
        StubTreeStatisticsAnalysis.updateStatistic((TreeStatistics<ISegment>)chlid2Stats, 3000);
        @NonNull TreeStatistics grandChild11Stats = new TreeStatistics(ISegment::getLength, "grandChild11");
        StubTreeStatisticsAnalysis.updateStatistic((TreeStatistics<ISegment>)grandChild11Stats, 4000);
        @NonNull TreeStatistics grandChild12Stats = new TreeStatistics(ISegment::getLength, "grandChild12");
        StubTreeStatisticsAnalysis.updateStatistic((TreeStatistics<ISegment>)grandChild12Stats, 5000);
        @NonNull TreeStatistics grandChild21Stats = new TreeStatistics(ISegment::getLength, "grandChild21");
        StubTreeStatisticsAnalysis.updateStatistic((TreeStatistics<ISegment>)grandChild21Stats, 6000);
        @NonNull TreeStatistics grandChild22Stats = new TreeStatistics(ISegment::getLength, "grandChild22");
        StubTreeStatisticsAnalysis.updateStatistic((TreeStatistics<ISegment>)grandChild22Stats, 7000);
        chlid1Stats.addChild((ITreeStatistics)grandChild11Stats);
        chlid1Stats.addChild((ITreeStatistics)grandChild12Stats);
        chlid2Stats.addChild((ITreeStatistics)grandChild21Stats);
        chlid2Stats.addChild((ITreeStatistics)grandChild22Stats);
        rootStats.addChild((ITreeStatistics)chlid1Stats);
        rootStats.addChild((ITreeStatistics)chlid2Stats);
        return rootStats;
    }

    private static void updateStatistic(TreeStatistics<@NonNull ISegment> statistic, int number) {
        int i = 0;
        while (i < 3) {
            BasicSegment segment = new BasicSegment((long)number, (long)(number + i));
            statistic.update((Object)segment);
            ++i;
        }
    }
}

