/**
 * Copyright (c) 2010-2018, Zoltan Ujhelyi, Istvan Rath, Daniel Varro, IncQuery Labs Ltd.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-v20.html.
 *  * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.viatra.query.patternlanguage.emf.vql.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.emf.ecore.plugin.EcorePlugin;

import org.eclipse.viatra.query.patternlanguage.emf.vql.*;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class PatternLanguageFactoryImpl extends EFactoryImpl implements PatternLanguageFactory
{
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static PatternLanguageFactory init()
	{
		try
		{
			PatternLanguageFactory thePatternLanguageFactory = (PatternLanguageFactory)EPackage.Registry.INSTANCE.getEFactory(PatternLanguagePackage.eNS_URI);
			if (thePatternLanguageFactory != null)
			{
				return thePatternLanguageFactory;
			}
		}
		catch (Exception exception)
		{
			EcorePlugin.INSTANCE.log(exception);
		}
		return new PatternLanguageFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PatternLanguageFactoryImpl()
	{
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass)
	{
		switch (eClass.getClassifierID())
		{
			case PatternLanguagePackage.VQL_IMPORT_SECTION: return createVQLImportSection();
			case PatternLanguagePackage.PACKAGE_IMPORT: return createPackageImport();
			case PatternLanguagePackage.PATTERN_IMPORT: return createPatternImport();
			case PatternLanguagePackage.ECLASSIFIER_CONSTRAINT: return createEClassifierConstraint();
			case PatternLanguagePackage.ENUM_VALUE: return createEnumValue();
			case PatternLanguagePackage.PATTERN_MODEL: return createPatternModel();
			case PatternLanguagePackage.CLASS_TYPE: return createClassType();
			case PatternLanguagePackage.REFERENCE_TYPE: return createReferenceType();
			case PatternLanguagePackage.PATTERN: return createPattern();
			case PatternLanguagePackage.ANNOTATION: return createAnnotation();
			case PatternLanguagePackage.ANNOTATION_PARAMETER: return createAnnotationParameter();
			case PatternLanguagePackage.MODIFIERS: return createModifiers();
			case PatternLanguagePackage.EXPRESSION: return createExpression();
			case PatternLanguagePackage.VARIABLE: return createVariable();
			case PatternLanguagePackage.VARIABLE_REFERENCE: return createVariableReference();
			case PatternLanguagePackage.TYPE: return createType();
			case PatternLanguagePackage.ENTITY_TYPE: return createEntityType();
			case PatternLanguagePackage.PATTERN_BODY: return createPatternBody();
			case PatternLanguagePackage.CONSTRAINT: return createConstraint();
			case PatternLanguagePackage.PATTERN_CALL: return createPatternCall();
			case PatternLanguagePackage.VALUE_REFERENCE: return createValueReference();
			case PatternLanguagePackage.LITERAL_VALUE_REFERENCE: return createLiteralValueReference();
			case PatternLanguagePackage.COMPUTATION_VALUE: return createComputationValue();
			case PatternLanguagePackage.PARAMETER_REF: return createParameterRef();
			case PatternLanguagePackage.PARAMETER: return createParameter();
			case PatternLanguagePackage.LOCAL_VARIABLE: return createLocalVariable();
			case PatternLanguagePackage.JAVA_TYPE: return createJavaType();
			case PatternLanguagePackage.RELATION_TYPE: return createRelationType();
			case PatternLanguagePackage.TYPE_CHECK_CONSTRAINT: return createTypeCheckConstraint();
			case PatternLanguagePackage.PATTERN_COMPOSITION_CONSTRAINT: return createPatternCompositionConstraint();
			case PatternLanguagePackage.COMPARE_CONSTRAINT: return createCompareConstraint();
			case PatternLanguagePackage.CHECK_CONSTRAINT: return createCheckConstraint();
			case PatternLanguagePackage.PATH_EXPRESSION_CONSTRAINT: return createPathExpressionConstraint();
			case PatternLanguagePackage.STRING_VALUE: return createStringValue();
			case PatternLanguagePackage.NUMBER_VALUE: return createNumberValue();
			case PatternLanguagePackage.BOOL_VALUE: return createBoolValue();
			case PatternLanguagePackage.LIST_VALUE: return createListValue();
			case PatternLanguagePackage.FUNCTION_EVALUATION_VALUE: return createFunctionEvaluationValue();
			case PatternLanguagePackage.AGGREGATED_VALUE: return createAggregatedValue();
			case PatternLanguagePackage.JAVA_CONSTANT_VALUE: return createJavaConstantValue();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object createFromString(EDataType eDataType, String initialValue)
	{
		switch (eDataType.getClassifierID())
		{
			case PatternLanguagePackage.EXECUTION_TYPE:
				return createExecutionTypeFromString(eDataType, initialValue);
			case PatternLanguagePackage.PARAMETER_DIRECTION:
				return createParameterDirectionFromString(eDataType, initialValue);
			case PatternLanguagePackage.COMPARE_FEATURE:
				return createCompareFeatureFromString(eDataType, initialValue);
			case PatternLanguagePackage.CLOSURE_TYPE:
				return createClosureTypeFromString(eDataType, initialValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String convertToString(EDataType eDataType, Object instanceValue)
	{
		switch (eDataType.getClassifierID())
		{
			case PatternLanguagePackage.EXECUTION_TYPE:
				return convertExecutionTypeToString(eDataType, instanceValue);
			case PatternLanguagePackage.PARAMETER_DIRECTION:
				return convertParameterDirectionToString(eDataType, instanceValue);
			case PatternLanguagePackage.COMPARE_FEATURE:
				return convertCompareFeatureToString(eDataType, instanceValue);
			case PatternLanguagePackage.CLOSURE_TYPE:
				return convertClosureTypeToString(eDataType, instanceValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public VQLImportSection createVQLImportSection()
	{
		VQLImportSectionImpl vqlImportSection = new VQLImportSectionImpl();
		return vqlImportSection;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PackageImport createPackageImport()
	{
		PackageImportImpl packageImport = new PackageImportImpl();
		return packageImport;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PatternImport createPatternImport()
	{
		PatternImportImpl patternImport = new PatternImportImpl();
		return patternImport;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClassifierConstraint createEClassifierConstraint()
	{
		EClassifierConstraintImpl eClassifierConstraint = new EClassifierConstraintImpl();
		return eClassifierConstraint;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EnumValue createEnumValue()
	{
		EnumValueImpl enumValue = new EnumValueImpl();
		return enumValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PatternModel createPatternModel()
	{
		PatternModelImpl patternModel = new PatternModelImpl();
		return patternModel;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ClassType createClassType()
	{
		ClassTypeImpl classType = new ClassTypeImpl();
		return classType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ReferenceType createReferenceType()
	{
		ReferenceTypeImpl referenceType = new ReferenceTypeImpl();
		return referenceType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Pattern createPattern()
	{
		PatternImpl pattern = new PatternImpl();
		return pattern;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Annotation createAnnotation()
	{
		AnnotationImpl annotation = new AnnotationImpl();
		return annotation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AnnotationParameter createAnnotationParameter()
	{
		AnnotationParameterImpl annotationParameter = new AnnotationParameterImpl();
		return annotationParameter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Modifiers createModifiers()
	{
		ModifiersImpl modifiers = new ModifiersImpl();
		return modifiers;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Expression createExpression()
	{
		ExpressionImpl expression = new ExpressionImpl();
		return expression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Variable createVariable()
	{
		VariableImpl variable = new VariableImpl();
		return variable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public VariableReference createVariableReference()
	{
		VariableReferenceImpl variableReference = new VariableReferenceImpl();
		return variableReference;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Type createType()
	{
		TypeImpl type = new TypeImpl();
		return type;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EntityType createEntityType()
	{
		EntityTypeImpl entityType = new EntityTypeImpl();
		return entityType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PatternBody createPatternBody()
	{
		PatternBodyImpl patternBody = new PatternBodyImpl();
		return patternBody;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Constraint createConstraint()
	{
		ConstraintImpl constraint = new ConstraintImpl();
		return constraint;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PatternCall createPatternCall()
	{
		PatternCallImpl patternCall = new PatternCallImpl();
		return patternCall;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ValueReference createValueReference()
	{
		ValueReferenceImpl valueReference = new ValueReferenceImpl();
		return valueReference;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public LiteralValueReference createLiteralValueReference()
	{
		LiteralValueReferenceImpl literalValueReference = new LiteralValueReferenceImpl();
		return literalValueReference;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComputationValue createComputationValue()
	{
		ComputationValueImpl computationValue = new ComputationValueImpl();
		return computationValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ParameterRef createParameterRef()
	{
		ParameterRefImpl parameterRef = new ParameterRefImpl();
		return parameterRef;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Parameter createParameter()
	{
		ParameterImpl parameter = new ParameterImpl();
		return parameter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public LocalVariable createLocalVariable()
	{
		LocalVariableImpl localVariable = new LocalVariableImpl();
		return localVariable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public JavaType createJavaType()
	{
		JavaTypeImpl javaType = new JavaTypeImpl();
		return javaType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RelationType createRelationType()
	{
		RelationTypeImpl relationType = new RelationTypeImpl();
		return relationType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TypeCheckConstraint createTypeCheckConstraint()
	{
		TypeCheckConstraintImpl typeCheckConstraint = new TypeCheckConstraintImpl();
		return typeCheckConstraint;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PatternCompositionConstraint createPatternCompositionConstraint()
	{
		PatternCompositionConstraintImpl patternCompositionConstraint = new PatternCompositionConstraintImpl();
		return patternCompositionConstraint;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CompareConstraint createCompareConstraint()
	{
		CompareConstraintImpl compareConstraint = new CompareConstraintImpl();
		return compareConstraint;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CheckConstraint createCheckConstraint()
	{
		CheckConstraintImpl checkConstraint = new CheckConstraintImpl();
		return checkConstraint;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PathExpressionConstraint createPathExpressionConstraint()
	{
		PathExpressionConstraintImpl pathExpressionConstraint = new PathExpressionConstraintImpl();
		return pathExpressionConstraint;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public StringValue createStringValue()
	{
		StringValueImpl stringValue = new StringValueImpl();
		return stringValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NumberValue createNumberValue()
	{
		NumberValueImpl numberValue = new NumberValueImpl();
		return numberValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BoolValue createBoolValue()
	{
		BoolValueImpl boolValue = new BoolValueImpl();
		return boolValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ListValue createListValue()
	{
		ListValueImpl listValue = new ListValueImpl();
		return listValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FunctionEvaluationValue createFunctionEvaluationValue()
	{
		FunctionEvaluationValueImpl functionEvaluationValue = new FunctionEvaluationValueImpl();
		return functionEvaluationValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AggregatedValue createAggregatedValue()
	{
		AggregatedValueImpl aggregatedValue = new AggregatedValueImpl();
		return aggregatedValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public JavaConstantValue createJavaConstantValue()
	{
		JavaConstantValueImpl javaConstantValue = new JavaConstantValueImpl();
		return javaConstantValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExecutionType createExecutionTypeFromString(EDataType eDataType, String initialValue)
	{
		ExecutionType result = ExecutionType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertExecutionTypeToString(EDataType eDataType, Object instanceValue)
	{
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ParameterDirection createParameterDirectionFromString(EDataType eDataType, String initialValue)
	{
		ParameterDirection result = ParameterDirection.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertParameterDirectionToString(EDataType eDataType, Object instanceValue)
	{
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CompareFeature createCompareFeatureFromString(EDataType eDataType, String initialValue)
	{
		CompareFeature result = CompareFeature.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertCompareFeatureToString(EDataType eDataType, Object instanceValue)
	{
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ClosureType createClosureTypeFromString(EDataType eDataType, String initialValue)
	{
		ClosureType result = ClosureType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertClosureTypeToString(EDataType eDataType, Object instanceValue)
	{
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PatternLanguagePackage getPatternLanguagePackage()
	{
		return (PatternLanguagePackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static PatternLanguagePackage getPackage()
	{
		return PatternLanguagePackage.eINSTANCE;
	}

} //PatternLanguageFactoryImpl
