/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.runtime.internal.ui.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.virgo.ide.runtime.core.IServerWorkingCopy;
import org.eclipse.virgo.ide.runtime.internal.core.actions.ModifyArtefactOrderCommand;
import org.eclipse.virgo.ide.runtime.internal.ui.editor.Messages;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.ui.ServerUICore;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;

public class ArtefactOrderEditorSection
extends ServerEditorSection {
    protected IServerWorkingCopy serverWorkingCopy;
    private List<IModule> orderedModules;
    protected boolean updating;
    protected PropertyChangeListener listener;
    private Table bundleTable;
    private TableViewer bundleTableViewer;
    private Button upButton;
    private Button downButton;

    protected void addConfigurationChangeListener() {
        this.listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (ArtefactOrderEditorSection.this.updating) {
                    return;
                }
                ArtefactOrderEditorSection.this.updating = true;
                if ("org.eclipse.virgo.ide.runtime.coreartefact.deploy.order".equals(event.getPropertyName())) {
                    ArtefactOrderEditorSection.this.initialize();
                }
                ArtefactOrderEditorSection.this.updating = false;
            }
        };
        this.serverWorkingCopy.addConfigurationChangeListener(this.listener);
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        FormToolkit toolkit = this.getFormToolkit(parent.getDisplay());
        Section section = toolkit.createSection(parent, 458);
        section.setText(Messages.ArtefactOrderEditorSection_title);
        section.setDescription(Messages.ArtefactOrderEditorSection_description);
        section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768, 1040, true, true));
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
        this.bundleTable = toolkit.createTable(composite, 66050);
        GridData data = new GridData(4, 4, true, false);
        int modulesNumber = this.server.getModules().length;
        int heightHint = this.bundleTable.getItemHeight() * Math.min(Math.max(5, modulesNumber), 10) + this.bundleTable.getBorderWidth() * 2;
        data.heightHint = Math.min(200, heightHint);
        this.bundleTable.setLayoutData((Object)data);
        this.bundleTableViewer = new TableViewer(this.bundleTable);
        this.bundleTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.bundleTableViewer.setLabelProvider((IBaseLabelProvider)ServerUICore.getLabelProvider());
        this.bundleTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ArtefactOrderEditorSection.this.updateButtons(event.getSelection());
            }
        });
        Composite buttonComposite = new Composite(composite, 0);
        buttonComposite.setLayout((Layout)new GridLayout(1, true));
        data = new GridData(16384, 128, false, false);
        buttonComposite.setLayoutData((Object)data);
        this.upButton = toolkit.createButton(buttonComposite, Messages.ArtefactOrderEditorSection_up_button, 8);
        data = new GridData();
        this.upButton.setLayoutData((Object)data);
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ArtefactOrderEditorSection.this.bundleTableViewer.getSelection();
                ArrayList<IModule> allModules = new ArrayList<IModule>(ArtefactOrderEditorSection.this.orderedModules);
                for (IModule aModule : selection.toList()) {
                    int index = allModules.indexOf(aModule);
                    allModules.remove(aModule);
                    allModules.add(index - 1, aModule);
                }
                ArtefactOrderEditorSection.this.execute((IUndoableOperation)new ModifyArtefactOrderEditorCommand(allModules));
                ArtefactOrderEditorSection.this.updateButtons((ISelection)selection);
            }
        });
        this.downButton = toolkit.createButton(buttonComposite, Messages.ArtefactOrderEditorSection_down_button, 8);
        this.downButton.setLayoutData((Object)data);
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ArtefactOrderEditorSection.this.bundleTableViewer.getSelection();
                ArrayList<IModule> allModules = new ArrayList<IModule>(ArtefactOrderEditorSection.this.orderedModules);
                ArrayList reversedSelection = new ArrayList(selection.toList());
                Collections.reverse(reversedSelection);
                for (IModule aModule : reversedSelection) {
                    int index = allModules.indexOf(aModule);
                    allModules.remove(aModule);
                    allModules.add(index + 1, aModule);
                }
                ArtefactOrderEditorSection.this.execute((IUndoableOperation)new ModifyArtefactOrderEditorCommand(allModules));
                ArtefactOrderEditorSection.this.updateButtons((ISelection)selection);
            }
        });
        this.initialize();
    }

    public void dispose() {
        if (this.server != null) {
            this.server.removePropertyChangeListener(this.listener);
        }
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.serverWorkingCopy = (IServerWorkingCopy)this.server.loadAdapter(IServerWorkingCopy.class, (IProgressMonitor)new NullProgressMonitor());
        this.addConfigurationChangeListener();
    }

    protected void initialize() {
        final List orderedArtefacts = this.serverWorkingCopy.getConfiguration().getArtefactOrder();
        this.orderedModules = new ArrayList<IModule>(Arrays.asList(this.server.getModules()));
        Collections.sort(this.orderedModules, new Comparator<IModule>(){

            @Override
            public int compare(IModule o1, IModule o2) {
                Integer m1 = orderedArtefacts.contains(o1.getId()) ? orderedArtefacts.indexOf(o1.getId()) : Integer.MAX_VALUE;
                Integer m2 = orderedArtefacts.contains(o2.getId()) ? orderedArtefacts.indexOf(o2.getId()) : Integer.MAX_VALUE;
                return m1.compareTo(m2);
            }
        });
        this.bundleTableViewer.setInput(this.orderedModules);
    }

    private void updateButtons(ISelection selections) {
        boolean initialState;
        IStructuredSelection ss = (IStructuredSelection)selections;
        List selectedModules = ss.toList();
        List<IModule> allModules = this.orderedModules;
        int lowerBound = allModules.size() - 1;
        boolean canMoveUp = initialState = !selections.isEmpty() && !allModules.isEmpty();
        boolean canMoveDown = initialState;
        int i = 0;
        while (i < selectedModules.size() && initialState) {
            IModule obj = (IModule)selectedModules.get(i);
            int index = allModules.indexOf(obj);
            canMoveUp = canMoveUp && index > 0;
            canMoveDown = canMoveDown && index < lowerBound;
            ++i;
        }
        this.upButton.setEnabled(canMoveUp);
        this.downButton.setEnabled(canMoveDown);
    }

    public void doSave(IProgressMonitor monitor) {
        ArrayList<String> artefactOrder = new ArrayList<String>();
        for (IModule module : this.orderedModules) {
            artefactOrder.add(module.getId());
        }
        if (!this.serverWorkingCopy.getArtefactOrder().equals(artefactOrder)) {
            this.updating = true;
            this.execute((IUndoableOperation)new ModifyArtefactOrderCommand(this.serverWorkingCopy, artefactOrder));
            this.updating = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ModifyArtefactOrderEditorCommand
    extends AbstractOperation {
        private List<IModule> oldOrder;
        private final List<IModule> newOrder;

        ModifyArtefactOrderEditorCommand(List<IModule> newOrder) {
            super("Modify artefact order in editor UI");
            this.newOrder = newOrder;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.oldOrder = ArtefactOrderEditorSection.this.orderedModules;
            ArtefactOrderEditorSection.this.orderedModules = this.newOrder;
            ArtefactOrderEditorSection.this.bundleTableViewer.setInput((Object)ArtefactOrderEditorSection.this.orderedModules);
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.execute(monitor, info);
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            ArtefactOrderEditorSection.this.orderedModules = this.oldOrder;
            this.oldOrder = null;
            ArtefactOrderEditorSection.this.bundleTableViewer.setInput((Object)ArtefactOrderEditorSection.this.orderedModules);
            return Status.OK_STATUS;
        }
    }
}

