/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.core.context.EmbeddedMapping;
import org.eclipse.jpt.core.context.EnumType;
import org.eclipse.jpt.core.context.EnumeratedConverter;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.core.context.ManyToManyMapping;
import org.eclipse.jpt.core.context.ManyToOneMapping;
import org.eclipse.jpt.core.context.OneToManyMapping;
import org.eclipse.jpt.core.context.OneToOneMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.TemporalConverter;
import org.eclipse.jpt.core.context.TransientMapping;
import org.eclipse.jpt.core.context.VersionMapping;
import org.eclipse.jpt.core.resource.java.BasicAnnotation;
import org.eclipse.jpt.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.core.resource.java.EnumeratedAnnotation;
import org.eclipse.jpt.core.resource.java.FetchType;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.TemporalAnnotation;
import org.eclipse.jpt.core.resource.java.TemporalType;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JavaBasicMappingTests
extends ContextModelTestCase {
    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    private ICompilationUnit createTestEntityWithBasicMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithBasicMappingFetchOptionalSpecified() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic", "javax.persistence.FetchType"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic(fetch=FetchType.EAGER, optional=false)").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithLob() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Lob"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Lob").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithEnumerated() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Enumerated", "javax.persistence.EnumType"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Enumerated(EnumType.STRING)").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithTemporal() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Temporal", "javax.persistence.TemporalType"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Temporal(TemporalType.TIMESTAMP)").append(CR);
            }
        });
    }

    public JavaBasicMappingTests(String name) {
        super(name);
    }

    public void testDefaultBasicGetDefaultFetch() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.FetchType.EAGER, (Object)basicMapping.getDefaultFetch());
    }

    public void testSpecifiedBasicGetDefaultFetch() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.FetchType.EAGER, (Object)basicMapping.getDefaultFetch());
    }

    public void testGetFetch() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.FetchType.EAGER, (Object)basicMapping.getFetch());
        basicMapping.setSpecifiedFetch(org.eclipse.jpt.core.context.FetchType.LAZY);
        JavaBasicMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.FetchType.LAZY, (Object)basicMapping.getFetch());
    }

    public void testGetSpecifiedFetch() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertNull((Object)basicMapping.getSpecifiedFetch());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        BasicAnnotation basic = (BasicAnnotation)attributeResource.getMappingAnnotation("javax.persistence.Basic");
        basic.setFetch(FetchType.LAZY);
        JavaBasicMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.FetchType.LAZY, (Object)basicMapping.getSpecifiedFetch());
    }

    public void testGetSpecifiedFetch2() throws Exception {
        this.createTestEntityWithBasicMappingFetchOptionalSpecified();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.FetchType.EAGER, (Object)basicMapping.getSpecifiedFetch());
    }

    public void testSetSpecifiedFetch() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertNull((Object)basicMapping.getSpecifiedFetch());
        basicMapping.setSpecifiedFetch(org.eclipse.jpt.core.context.FetchType.LAZY);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        BasicAnnotation basic = (BasicAnnotation)attributeResource.getMappingAnnotation("javax.persistence.Basic");
        JavaBasicMappingTests.assertEquals((Object)FetchType.LAZY, (Object)basic.getFetch());
        basicMapping.setSpecifiedFetch(null);
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Basic"));
    }

    public void testSetSpecifiedFetch2() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.createOrmXmlFile();
        this.getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setAccess(AccessType.PROPERTY);
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertNull((Object)basicMapping.getSpecifiedFetch());
        JavaBasicMappingTests.assertTrue((boolean)basicMapping.isDefault());
        basicMapping.setSpecifiedFetch(org.eclipse.jpt.core.context.FetchType.LAZY);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableProperties().next();
        BasicAnnotation basic = (BasicAnnotation)attributeResource.getMappingAnnotation("javax.persistence.Basic");
        JavaBasicMappingTests.assertEquals((Object)FetchType.LAZY, (Object)basic.getFetch());
        basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.FetchType.LAZY, (Object)basicMapping.getSpecifiedFetch());
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.setSpecifiedFetch(null);
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Basic"));
        basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
    }

    protected void createOrmXmlFile() throws Exception {
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    public void testSetBasicRemovedFromResourceModel() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        attributeResource.addSupportingAnnotation("javax.persistence.Temporal");
        attributeResource.addSupportingAnnotation("javax.persistence.Lob");
        attributeResource.addSupportingAnnotation("javax.persistence.Enumerated");
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        attributeResource.setMappingAnnotation(null);
        JavaBasicMappingTests.assertNotSame((Object)basicMapping, (Object)persistentAttribute.getMapping());
        basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertTrue((boolean)basicMapping.isDefault());
        JavaBasicMappingTests.assertEquals((String)"FOO", (String)basicMapping.getColumn().getSpecifiedName());
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Column"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Temporal"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Lob"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Enumerated"));
    }

    public void testBasicMorphToDefaultBasic() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        basicMapping.setSpecifiedConverter("enumeratedConverter");
        ((EnumeratedConverter)basicMapping.getSpecifiedConverter()).setSpecifiedEnumType(EnumType.STRING);
        attributeResource.addSupportingAnnotation("javax.persistence.Lob");
        attributeResource.addSupportingAnnotation("javax.persistence.Temporal");
        basicMapping.setSpecifiedFetch(org.eclipse.jpt.core.context.FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        JavaBasicMappingTests.assertEquals((String)"FOO", (String)((BasicMapping)persistentAttribute.getMapping()).getColumn().getSpecifiedName());
        JavaBasicMappingTests.assertEquals((Object)EnumType.STRING, (Object)((EnumeratedConverter)((BasicMapping)persistentAttribute.getMapping()).getSpecifiedConverter()).getEnumType());
        JavaBasicMappingTests.assertNull((Object)((BasicMapping)persistentAttribute.getMapping()).getSpecifiedFetch());
        JavaBasicMappingTests.assertNull((Object)((BasicMapping)persistentAttribute.getMapping()).getSpecifiedOptional());
        JavaBasicMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Basic"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Column"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Temporal"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Lob"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Enumerated"));
    }

    public void testBasicMorphToId() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        basicMapping.setSpecifiedConverter("temporalConverter");
        ((TemporalConverter)basicMapping.getSpecifiedConverter()).setTemporalType(org.eclipse.jpt.core.context.TemporalType.TIME);
        attributeResource.addSupportingAnnotation("javax.persistence.Lob");
        attributeResource.addSupportingAnnotation("javax.persistence.Enumerated");
        basicMapping.setSpecifiedFetch(org.eclipse.jpt.core.context.FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("id");
        JavaBasicMappingTests.assertEquals((String)"FOO", (String)((IdMapping)persistentAttribute.getMapping()).getColumn().getSpecifiedName());
        JavaBasicMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.TIME, (Object)((TemporalConverter)((IdMapping)persistentAttribute.getMapping()).getSpecifiedConverter()).getTemporalType());
        JavaBasicMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Basic"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Id"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Column"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Temporal"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Lob"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Enumerated"));
    }

    public void testBasicMorphToVersion() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        basicMapping.setSpecifiedConverter("temporalConverter");
        ((TemporalConverter)basicMapping.getSpecifiedConverter()).setTemporalType(org.eclipse.jpt.core.context.TemporalType.TIME);
        attributeResource.addSupportingAnnotation("javax.persistence.Lob");
        attributeResource.addSupportingAnnotation("javax.persistence.Enumerated");
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("version");
        JavaBasicMappingTests.assertEquals((String)"FOO", (String)((VersionMapping)persistentAttribute.getMapping()).getColumn().getSpecifiedName());
        JavaBasicMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.TIME, (Object)((TemporalConverter)((VersionMapping)persistentAttribute.getMapping()).getSpecifiedConverter()).getTemporalType());
        JavaBasicMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Basic"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Version"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Column"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Temporal"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Lob"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Enumerated"));
    }

    public void testBasicMorphToEmbedded() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        attributeResource.addSupportingAnnotation("javax.persistence.Temporal");
        attributeResource.addSupportingAnnotation("javax.persistence.Lob");
        attributeResource.addSupportingAnnotation("javax.persistence.Enumerated");
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("embedded");
        JavaBasicMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedMapping));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Basic"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Embedded"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Column"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Temporal"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Lob"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Enumerated"));
    }

    public void testBasicMorphToEmbeddedId() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        attributeResource.addSupportingAnnotation("javax.persistence.Temporal");
        attributeResource.addSupportingAnnotation("javax.persistence.Lob");
        attributeResource.addSupportingAnnotation("javax.persistence.Enumerated");
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("embeddedId");
        JavaBasicMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Basic"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.EmbeddedId"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Column"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Temporal"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Lob"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Enumerated"));
    }

    public void testBasicMorphToTransient() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        attributeResource.addSupportingAnnotation("javax.persistence.Temporal");
        attributeResource.addSupportingAnnotation("javax.persistence.Lob");
        attributeResource.addSupportingAnnotation("javax.persistence.Enumerated");
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("transient");
        JavaBasicMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof TransientMapping));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Basic"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Transient"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Column"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Temporal"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Lob"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Enumerated"));
    }

    public void testBasicMorphToOneToOne() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        attributeResource.addSupportingAnnotation("javax.persistence.Temporal");
        attributeResource.addSupportingAnnotation("javax.persistence.Lob");
        attributeResource.addSupportingAnnotation("javax.persistence.Enumerated");
        basicMapping.setSpecifiedFetch(org.eclipse.jpt.core.context.FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("oneToOne");
        JavaBasicMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToOneMapping));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.OneToOne"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Basic"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Column"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Temporal"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Lob"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Enumerated"));
    }

    public void testBasicMorphToOneToMany() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        attributeResource.addSupportingAnnotation("javax.persistence.Temporal");
        attributeResource.addSupportingAnnotation("javax.persistence.Lob");
        attributeResource.addSupportingAnnotation("javax.persistence.Enumerated");
        basicMapping.setSpecifiedFetch(org.eclipse.jpt.core.context.FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("oneToMany");
        JavaBasicMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToManyMapping));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Basic"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Column"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Temporal"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Lob"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Enumerated"));
    }

    public void testBasicMorphToManyToOne() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        attributeResource.addSupportingAnnotation("javax.persistence.Temporal");
        attributeResource.addSupportingAnnotation("javax.persistence.Lob");
        attributeResource.addSupportingAnnotation("javax.persistence.Enumerated");
        basicMapping.setSpecifiedFetch(org.eclipse.jpt.core.context.FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("manyToOne");
        JavaBasicMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToOneMapping));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.ManyToOne"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Basic"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Column"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Temporal"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Lob"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Enumerated"));
    }

    public void testBasicMorphToManyToMany() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        attributeResource.addSupportingAnnotation("javax.persistence.Temporal");
        attributeResource.addSupportingAnnotation("javax.persistence.Lob");
        attributeResource.addSupportingAnnotation("javax.persistence.Enumerated");
        basicMapping.setSpecifiedFetch(org.eclipse.jpt.core.context.FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("manyToMany");
        JavaBasicMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToManyMapping));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Basic"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Column"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Temporal"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Lob"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Enumerated"));
    }

    public void testDefaultBasicGetDefaultOptional() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertEquals((boolean)true, (boolean)basicMapping.isDefaultOptional());
    }

    public void testSpecifiedBasicGetDefaultOptional() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertEquals((boolean)true, (boolean)basicMapping.isDefaultOptional());
    }

    public void testGetOptional() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertEquals((boolean)true, (boolean)basicMapping.isOptional());
        basicMapping.setSpecifiedOptional(Boolean.TRUE);
        JavaBasicMappingTests.assertEquals((boolean)true, (boolean)basicMapping.isOptional());
    }

    public void testGetSpecifiedOptional() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertNull((Object)basicMapping.getSpecifiedOptional());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        BasicAnnotation basic = (BasicAnnotation)attributeResource.getMappingAnnotation("javax.persistence.Basic");
        basic.setOptional(Boolean.FALSE);
        JavaBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)basicMapping.getSpecifiedOptional());
    }

    public void testGetSpecifiedOptional2() throws Exception {
        this.createTestEntityWithBasicMappingFetchOptionalSpecified();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)basicMapping.getSpecifiedOptional());
    }

    public void testSetSpecifiedOptional() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertNull((Object)basicMapping.getSpecifiedOptional());
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        BasicAnnotation basic = (BasicAnnotation)attributeResource.getMappingAnnotation("javax.persistence.Basic");
        JavaBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)basic.getOptional());
        basicMapping.setSpecifiedOptional(null);
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Basic"));
    }

    public void testSetSpecifiedOptional2() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertNull((Object)basicMapping.getSpecifiedOptional());
        JavaBasicMappingTests.assertTrue((boolean)basicMapping.isDefault());
        basicMapping.setSpecifiedOptional(Boolean.TRUE);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        BasicAnnotation basic = (BasicAnnotation)attributeResource.getMappingAnnotation("javax.persistence.Basic");
        JavaBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)basic.getOptional());
        basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)basicMapping.getSpecifiedOptional());
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.setSpecifiedOptional(null);
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Basic"));
        basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
    }

    public void testGetSpecifiedOptionalUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertNull((Object)basicMapping.getSpecifiedOptional());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        BasicAnnotation basic = (BasicAnnotation)attributeResource.getMappingAnnotation("javax.persistence.Basic");
        basic.setOptional(Boolean.FALSE);
        JavaBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)basicMapping.getSpecifiedOptional());
        basic.setOptional(null);
        JavaBasicMappingTests.assertNull((Object)basicMapping.getSpecifiedOptional());
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        JavaBasicMappingTests.assertSame((Object)basicMapping, (Object)persistentAttribute.getSpecifiedMapping());
        basic.setOptional(Boolean.FALSE);
        attributeResource.setMappingAnnotation(null);
        JavaBasicMappingTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        JavaBasicMappingTests.assertEquals((boolean)true, (boolean)((BasicMapping)persistentAttribute.getMapping()).isOptional());
    }

    public void testIsLob() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertFalse((basicMapping.getConverter().getType() == "lobConverter" ? 1 : 0) != 0);
    }

    public void testIsLob2() throws Exception {
        this.createTestEntityWithLob();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertTrue((basicMapping.getConverter().getType() == "lobConverter" ? 1 : 0) != 0);
    }

    public void testSetLob() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        basicMapping.setSpecifiedConverter("lobConverter");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Lob"));
        basicMapping.setSpecifiedConverter(null);
        JavaBasicMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Lob"));
    }

    public void testIsLobUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertFalse((basicMapping.getConverter().getType() == "lobConverter" ? 1 : 0) != 0);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.addSupportingAnnotation("javax.persistence.Lob");
        JavaBasicMappingTests.assertTrue((basicMapping.getConverter().getType() == "lobConverter" ? 1 : 0) != 0);
        attributeResource.removeSupportingAnnotation("javax.persistence.Lob");
        JavaBasicMappingTests.assertFalse((basicMapping.getConverter().getType() == "lobConverter" ? 1 : 0) != 0);
    }

    public void testDefaultBasicGetDefaultConverter() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertTrue((basicMapping.getConverter().getType() == "noConverter" ? 1 : 0) != 0);
    }

    public void testSpecifiedBasicGetDefaultConverter() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertTrue((basicMapping.getConverter().getType() == "noConverter" ? 1 : 0) != 0);
    }

    public void testGetEnumerated() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertTrue((basicMapping.getConverter().getType() == "noConverter" ? 1 : 0) != 0);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EnumeratedAnnotation enumeratedAnnotation = (EnumeratedAnnotation)attributeResource.addSupportingAnnotation("javax.persistence.Enumerated");
        JavaBasicMappingTests.assertEquals((Object)EnumType.ORDINAL, (Object)((EnumeratedConverter)basicMapping.getConverter()).getDefaultEnumType());
        enumeratedAnnotation.setValue(org.eclipse.jpt.core.resource.java.EnumType.STRING);
        JavaBasicMappingTests.assertEquals((Object)EnumType.STRING, (Object)((EnumeratedConverter)basicMapping.getConverter()).getSpecifiedEnumType());
    }

    public void testGetSpecifiedEnumerated() throws Exception {
        this.createTestEntityWithEnumerated();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertEquals((Object)EnumType.STRING, (Object)((EnumeratedConverter)basicMapping.getConverter()).getSpecifiedEnumType());
    }

    public void testSetSpecifiedEnumerated() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertTrue((basicMapping.getConverter().getType() == "noConverter" ? 1 : 0) != 0);
        basicMapping.setSpecifiedConverter("enumeratedConverter");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EnumeratedAnnotation enumerated = (EnumeratedAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.Enumerated");
        JavaBasicMappingTests.assertNotNull((Object)enumerated);
        JavaBasicMappingTests.assertEquals(null, (Object)enumerated.getValue());
        ((EnumeratedConverter)basicMapping.getConverter()).setSpecifiedEnumType(EnumType.STRING);
        JavaBasicMappingTests.assertEquals((Object)org.eclipse.jpt.core.resource.java.EnumType.STRING, (Object)enumerated.getValue());
        ((EnumeratedConverter)basicMapping.getConverter()).setSpecifiedEnumType(null);
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Enumerated"));
        JavaBasicMappingTests.assertNull((Object)enumerated.getValue());
        basicMapping.setSpecifiedConverter("noConverter");
        JavaBasicMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Enumerated"));
    }

    public void testGetSpecifiedEnumeratedUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertTrue((basicMapping.getConverter().getType() == "noConverter" ? 1 : 0) != 0);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EnumeratedAnnotation enumerated = (EnumeratedAnnotation)attributeResource.addSupportingAnnotation("javax.persistence.Enumerated");
        enumerated.setValue(org.eclipse.jpt.core.resource.java.EnumType.STRING);
        JavaBasicMappingTests.assertEquals((Object)EnumType.STRING, (Object)((EnumeratedConverter)basicMapping.getConverter()).getSpecifiedEnumType());
        enumerated.setValue(null);
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Enumerated"));
        JavaBasicMappingTests.assertNull((Object)((EnumeratedConverter)basicMapping.getConverter()).getSpecifiedEnumType());
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        JavaBasicMappingTests.assertSame((Object)basicMapping, (Object)persistentAttribute.getSpecifiedMapping());
    }

    public void testGetTemporal() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.addSupportingAnnotation("javax.persistence.Temporal");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertEquals((String)"temporalConverter", (String)basicMapping.getConverter().getType());
    }

    public void testGetTemporal2() throws Exception {
        this.createTestEntityWithTemporal();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertEquals((String)"temporalConverter", (String)basicMapping.getConverter().getType());
        JavaBasicMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.TIMESTAMP, (Object)((TemporalConverter)basicMapping.getConverter()).getTemporalType());
    }

    public void testSetTemporal() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertEquals((String)"noConverter", (String)basicMapping.getConverter().getType());
        basicMapping.setSpecifiedConverter("temporalConverter");
        ((TemporalConverter)basicMapping.getSpecifiedConverter()).setTemporalType(org.eclipse.jpt.core.context.TemporalType.TIME);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TemporalAnnotation temporal = (TemporalAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.Temporal");
        JavaBasicMappingTests.assertEquals((Object)TemporalType.TIME, (Object)temporal.getValue());
        basicMapping.setSpecifiedConverter(null);
        JavaBasicMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Temporal"));
    }

    public void testGetTemporalUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertEquals((String)"noConverter", (String)basicMapping.getConverter().getType());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TemporalAnnotation temporal = (TemporalAnnotation)attributeResource.addSupportingAnnotation("javax.persistence.Temporal");
        temporal.setValue(TemporalType.DATE);
        JavaBasicMappingTests.assertEquals((String)"temporalConverter", (String)basicMapping.getConverter().getType());
        JavaBasicMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.DATE, (Object)((TemporalConverter)basicMapping.getConverter()).getTemporalType());
        attributeResource.removeSupportingAnnotation("javax.persistence.Temporal");
        JavaBasicMappingTests.assertEquals((String)"noConverter", (String)basicMapping.getConverter().getType());
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        JavaBasicMappingTests.assertSame((Object)basicMapping, (Object)persistentAttribute.getSpecifiedMapping());
    }

    public void testGetColumn() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        JavaBasicMappingTests.assertNull((Object)basicMapping.getColumn().getSpecifiedName());
        JavaBasicMappingTests.assertEquals((String)"id", (String)basicMapping.getColumn().getName());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.addSupportingAnnotation("javax.persistence.Column");
        column.setName("foo");
        JavaBasicMappingTests.assertEquals((String)"foo", (String)basicMapping.getColumn().getSpecifiedName());
        JavaBasicMappingTests.assertEquals((String)"foo", (String)basicMapping.getColumn().getName());
        JavaBasicMappingTests.assertEquals((String)"id", (String)basicMapping.getColumn().getDefaultName());
    }
}

