/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.core.context.EmbeddedMapping;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.core.context.ManyToManyMapping;
import org.eclipse.jpt.core.context.ManyToOneMapping;
import org.eclipse.jpt.core.context.OneToManyMapping;
import org.eclipse.jpt.core.context.OneToOneMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.TransientMapping;
import org.eclipse.jpt.core.context.VersionMapping;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JavaTransientMappingTests
extends ContextModelTestCase {
    private ICompilationUnit createTestEntityWithTransientMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Transient"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Transient").append(CR);
            }
        });
    }

    public JavaTransientMappingTests(String name) {
        super(name);
    }

    public void testMorphToBasicMapping() throws Exception {
        this.createTestEntityWithTransientMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        TransientMapping transientMapping = (TransientMapping)persistentAttribute.getMapping();
        JavaTransientMappingTests.assertFalse((boolean)transientMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("basic");
        JavaTransientMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof BasicMapping));
        JavaTransientMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaTransientMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Transient"));
        JavaTransientMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Basic"));
    }

    public void testMorphToDefault() throws Exception {
        this.createTestEntityWithTransientMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        TransientMapping transientMapping = (TransientMapping)persistentAttribute.getMapping();
        JavaTransientMappingTests.assertFalse((boolean)transientMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        JavaTransientMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof BasicMapping));
        JavaTransientMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaTransientMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Transient"));
    }

    public void testMorphToVersionMapping() throws Exception {
        this.createTestEntityWithTransientMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        TransientMapping transientMapping = (TransientMapping)persistentAttribute.getMapping();
        JavaTransientMappingTests.assertFalse((boolean)transientMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("version");
        JavaTransientMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof VersionMapping));
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaTransientMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Transient"));
        JavaTransientMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Version"));
    }

    public void testMorphToEmbeddedMapping() throws Exception {
        this.createTestEntityWithTransientMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        TransientMapping transientMapping = (TransientMapping)persistentAttribute.getMapping();
        JavaTransientMappingTests.assertFalse((boolean)transientMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("embedded");
        JavaTransientMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedMapping));
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaTransientMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Transient"));
        JavaTransientMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Embedded"));
    }

    public void testMorphToIdMapping() throws Exception {
        this.createTestEntityWithTransientMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        TransientMapping transientMapping = (TransientMapping)persistentAttribute.getMapping();
        JavaTransientMappingTests.assertFalse((boolean)transientMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("id");
        JavaTransientMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof IdMapping));
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaTransientMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Transient"));
        JavaTransientMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Id"));
    }

    public void testMorphToEmbeddedIdMapping() throws Exception {
        this.createTestEntityWithTransientMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        TransientMapping transientMapping = (TransientMapping)persistentAttribute.getMapping();
        JavaTransientMappingTests.assertFalse((boolean)transientMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("embeddedId");
        JavaTransientMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaTransientMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Transient"));
        JavaTransientMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.EmbeddedId"));
    }

    public void testMorphToOneToOneMapping() throws Exception {
        this.createTestEntityWithTransientMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        TransientMapping transientMapping = (TransientMapping)persistentAttribute.getMapping();
        JavaTransientMappingTests.assertFalse((boolean)transientMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("oneToOne");
        JavaTransientMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToOneMapping));
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaTransientMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Transient"));
        JavaTransientMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.OneToOne"));
    }

    public void testMorphToOneToManyMapping() throws Exception {
        this.createTestEntityWithTransientMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        TransientMapping transientMapping = (TransientMapping)persistentAttribute.getMapping();
        JavaTransientMappingTests.assertFalse((boolean)transientMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("oneToMany");
        JavaTransientMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToManyMapping));
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaTransientMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Transient"));
        JavaTransientMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.OneToMany"));
    }

    public void testMorphToManyToOneMapping() throws Exception {
        this.createTestEntityWithTransientMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        TransientMapping transientMapping = (TransientMapping)persistentAttribute.getMapping();
        JavaTransientMappingTests.assertFalse((boolean)transientMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("manyToOne");
        JavaTransientMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToOneMapping));
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaTransientMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Transient"));
        JavaTransientMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.ManyToOne"));
    }

    public void testMorphToManyToManyMapping() throws Exception {
        this.createTestEntityWithTransientMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        TransientMapping transientMapping = (TransientMapping)persistentAttribute.getMapping();
        JavaTransientMappingTests.assertFalse((boolean)transientMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("manyToMany");
        JavaTransientMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToManyMapping));
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaTransientMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Transient"));
        JavaTransientMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.ManyToMany"));
    }

    public void testTransientMapping() throws Exception {
        this.createTestEntityWithTransientMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        TransientMapping transientMapping = (TransientMapping)persistentAttribute.getSpecifiedMapping();
        JavaTransientMappingTests.assertNotNull((Object)transientMapping);
    }
}

