/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AttrType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.CommentType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.DocType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.ElementType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.PIType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.TextType;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public abstract class NodeType
extends AnyType {
    private Node _node;
    private int _document_order;

    public NodeType(Node node, int document_order) {
        this._node = node;
        this._document_order = document_order;
    }

    public Node node_value() {
        return this._node;
    }

    public int document_order() {
        return this._document_order;
    }

    public abstract ResultSequence typed_value();

    public abstract QName node_name();

    public ResultSequence nilled() {
        return ResultSequenceFactory.create_new();
    }

    public static NodeType dom_to_xpath(Node node, int doc_pos) {
        switch (node.getNodeType()) {
            case 1: {
                return new ElementType((Element)node, doc_pos);
            }
            case 8: {
                return new CommentType((Comment)node, doc_pos);
            }
            case 2: {
                return new AttrType((Attr)node, doc_pos);
            }
            case 3: {
                return new TextType((Text)node, doc_pos);
            }
            case 9: {
                return new DocType((Document)node, doc_pos);
            }
            case 7: {
                return new PIType((ProcessingInstruction)node, doc_pos);
            }
        }
        assert (false);
        return null;
    }

    public static ResultSequence eliminate_dups(ResultSequence rs) {
        Hashtable<Node, Boolean> added = new Hashtable<Node, Boolean>(rs.size());
        ListIterator i = rs.iterator();
        while (i.hasNext()) {
            NodeType node = (NodeType)i.next();
            Node n = node.node_value();
            if (added.containsKey(n)) {
                i.remove();
                continue;
            }
            added.put(n, new Boolean(true));
        }
        return rs;
    }

    public static ResultSequence sort_document_order(ResultSequence rs) {
        ArrayList<NodeType> res = new ArrayList<NodeType>(rs.size());
        Iterator i = rs.iterator();
        while (i.hasNext()) {
            NodeType node = (NodeType)i.next();
            boolean added = false;
            int j = 0;
            while (j < res.size()) {
                NodeType x = (NodeType)res.get(j);
                if (NodeType.before(node, x)) {
                    res.add(j, node);
                    added = true;
                    break;
                }
                ++j;
            }
            if (added) continue;
            res.add(node);
        }
        rs = ResultSequenceFactory.create_new();
        for (NodeType node : res) {
            rs.add(node);
        }
        return rs;
    }

    public static boolean same(NodeType a, NodeType b) {
        return a.document_order() == b.document_order();
    }

    public boolean before(NodeType two) {
        return NodeType.before(this, two);
    }

    public static boolean before(NodeType a, NodeType b) {
        return a.document_order() < b.document_order();
    }

    public boolean after(NodeType two) {
        return NodeType.after(this, two);
    }

    public static boolean after(NodeType a, NodeType b) {
        if (NodeType.same(a, b)) {
            return false;
        }
        return !NodeType.before(a, b);
    }
}

