/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpEq;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.CtrType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;

public class QName
extends CtrType
implements CmpEq {
    private String _namespace;
    private String _prefix;
    private String _local_part;
    private boolean _expanded;

    public QName(String prefix, String local_part, String ns) {
        this(prefix, local_part);
        this.set_namespace(ns);
    }

    public QName(String prefix, String local_part) {
        this._prefix = prefix;
        this._local_part = local_part;
        this._expanded = false;
    }

    public QName(String local_part) {
        this(null, local_part);
        this.set_namespace(null);
    }

    public QName() {
        this(null, null);
    }

    public static QName parse_QName(String str) {
        String[] tokens = str.split(":");
        if (tokens.length == 1) {
            return new QName(tokens[0]);
        }
        if (tokens.length == 2) {
            return new QName(tokens[0], tokens[1]);
        }
        return null;
    }

    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        String sarg;
        QName qname;
        AnyAtomicType aat;
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (arg.empty()) {
            DynamicError.throw_type_error();
        }
        if (!((aat = (AnyAtomicType)arg.first()) instanceof XSString)) {
            DynamicError.throw_type_error();
        }
        if ((qname = QName.parse_QName(sarg = ((XSString)aat).value())) == null) {
            return null;
        }
        rs.add(qname);
        return rs;
    }

    public String string_value() {
        return this.string();
    }

    public String string_type() {
        return "xs:QName";
    }

    public String type_name() {
        return "QName";
    }

    public String string() {
        String res = "";
        if (this._prefix != null) {
            res = String.valueOf(this._prefix) + ":";
        }
        res = String.valueOf(res) + this._local_part;
        return res;
    }

    public String expanded_name() {
        assert (this._expanded);
        String e = "";
        if (this._namespace != null) {
            e = String.valueOf(e) + this._namespace + ":";
        }
        return String.valueOf(e) + this._local_part;
    }

    public String prefix() {
        return this._prefix;
    }

    public void set_namespace(String n) {
        this._namespace = n;
        this._expanded = true;
    }

    public String namespace() {
        assert (this._expanded);
        return this._namespace;
    }

    public String local() {
        return this._local_part;
    }

    public boolean expanded() {
        return this._expanded;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof QName)) {
            return false;
        }
        QName arg = (QName)obj;
        if (!this._expanded || !arg.expanded()) {
            assert (false);
            return false;
        }
        String argn = arg.namespace();
        if (this._namespace != null ? !this._namespace.equals(argn) : argn != null) {
            return false;
        }
        String argl = arg.local();
        return !(this._local_part != null ? !this._local_part.equals(argl) : argl != null);
    }

    public int hashCode() {
        int namespace = 3;
        int local = 4;
        int result = 0;
        assert (this.expanded());
        if (this._namespace != null) {
            namespace = this._namespace.hashCode();
        }
        if (this._local_part != null) {
            local = this._local_part.hashCode();
        }
        result = namespace;
        result ^= 2 * local;
        if (this._expanded) {
            result ^= result + 1;
        }
        return result;
    }

    public boolean eq(AnyType arg) throws DynamicError {
        QName val = (QName)NumericType.get_single_type(arg, QName.class);
        return this.equals(val);
    }
}

