/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.core.Signature;
import org.eclipse.wtp.releng.tools.component.api.JavadocCoverage;
import org.eclipse.wtp.releng.tools.component.api.TestCoverage;
import org.eclipse.wtp.releng.tools.component.internal.ComponentObject;

public class MethodAPI
extends ComponentObject {
    private String name;
    private int access = -1;
    private String descriptor;
    private List throwTypes;
    private TestCoverage testCoverage;
    private JavadocCoverage javadocCoverage;

    public int getAccess() {
        return this.access;
    }

    public void setAccess(int access) {
        this.access = access;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(String descriptor) {
        this.descriptor = descriptor;
    }

    public String getName() {
        StringBuffer sb = new StringBuffer(this.name);
        int index = this.name.indexOf(60);
        while (index != -1) {
            sb.deleteCharAt(index);
            sb.insert(index, new char[]{'&', 'l', 't', ';'}, 0, 4);
            index = sb.toString().indexOf(60);
        }
        return sb.toString();
    }

    public void setName(String name) {
        StringBuffer sb = new StringBuffer(name);
        int index = name.indexOf("&lt;");
        while (index != -1) {
            sb.delete(index, index + 4);
            sb.insert(index, '<');
            index = sb.toString().indexOf("&lt;");
        }
        this.name = sb.toString();
    }

    public List getThrows() {
        if (this.throwTypes == null) {
            this.throwTypes = new ArrayList(1);
        }
        return this.throwTypes;
    }

    public void addThrows(Collection throwTypes) {
        if (throwTypes == null) {
            throwTypes = new ArrayList(throwTypes);
        } else {
            throwTypes.addAll(throwTypes);
        }
    }

    public int sizeThrows() {
        return this.throwTypes == null ? 0 : this.throwTypes.size();
    }

    public List getInputs() {
        String[] encodedInputs = Signature.getParameterTypes((String)this.getDescriptor());
        ArrayList<String> decodedInputs = new ArrayList<String>(encodedInputs.length);
        int i = 0;
        while (i < encodedInputs.length) {
            decodedInputs.add(this.decodeDescriptor(encodedInputs[i]));
            ++i;
        }
        return decodedInputs;
    }

    public String getReturn() {
        return this.decodeDescriptor(Signature.getReturnType((String)this.getDescriptor()));
    }

    private String decodeDescriptor(String descriptor) {
        return this.decodeClassName(Signature.toString((String)descriptor));
    }

    private String decodeClassName(String className) {
        return className.replace('/', '.');
    }

    public TestCoverage getTestCoverage() {
        if (this.testCoverage == null) {
            this.testCoverage = new TestCoverage();
        }
        return this.testCoverage;
    }

    public void setTestCoverage(TestCoverage testCoverage) {
        this.testCoverage = testCoverage;
    }

    public int countTestcases() {
        return this.testCoverage != null ? this.testCoverage.getTests().size() : 0;
    }

    public JavadocCoverage getJavadocCoverage() {
        if (this.javadocCoverage == null) {
            this.javadocCoverage = new JavadocCoverage();
        }
        return this.javadocCoverage;
    }

    public void setJavadocCoverage(JavadocCoverage javadocCoverage) {
        this.javadocCoverage = javadocCoverage;
    }

    public boolean isSetJavadocCoverage() {
        return this.javadocCoverage != null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<method-api");
        sb.append(this.toAttribute("name", this.getName()));
        sb.append(this.toAttribute("descriptor", this.getDescriptor()));
        int access = this.getAccess();
        if (access != -1) {
            sb.append(this.toAttribute("access", String.valueOf(access)));
        }
        if (this.sizeThrows() > 0) {
            sb.append(this.toAttribute("throws", this.getThrows(), " "));
        }
        sb.append(">");
        if (this.testCoverage != null) {
            sb.append(this.testCoverage.toString());
        }
        if (this.javadocCoverage != null) {
            sb.append(this.javadocCoverage.toString());
        }
        sb.append("</method-api>");
        return sb.toString();
    }
}

