import { LikeSocket } from 'noice-json-rpc';
export declare class CRDPMultiplexor {
    private _wrappedLikeSocket;
    private _channels;
    private onMessage(data);
    private onResponseMessage(message, data);
    private onDomainNotification(message, data);
    constructor(_wrappedLikeSocket: LikeSocket);
    addChannel(channelName: string): CRDPChannel;
    send(channel: CRDPChannel, data: string): void;
    addListenerOfNonMultiplexedEvent(event: string, cb: Function): void;
    removeListenerOfNonMultiplexedEvent(event: string, cb: Function): void;
}
export declare class CRDPChannel implements LikeSocket {
    name: string;
    id: number;
    private _multiplexor;
    private static timeToPreserveMessagesInMillis;
    private _messageCallbacks;
    private _enabledDomains;
    private _pendingMessagesForDomain;
    callMessageCallbacks(messageData: string): void;
    callDomainMessageCallbacks(domain: string, messageData: string): void;
    private storeMessageForLater(domain, messageData);
    constructor(name: string, id: number, _multiplexor: CRDPMultiplexor);
    send(messageData: string): void;
    private sendUnsentPendingMessages(domain);
    private discardUnsentPendingMessages();
    on(event: string, cb: Function): void;
    on(event: 'open', cb: (ws: LikeSocket) => void): void;
    on(event: 'message', cb: (data: string) => void): void;
    removeListener(event: string, cb: Function): void;
}
