/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.model;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.tm4e.core.model.AbstractModelLines;
import org.eclipse.tm4e.ui.TMUIPlugin;
import org.eclipse.tm4e.ui.internal.model.DocumentHelper;

final class DocumentModelLines
extends AbstractModelLines
implements IDocumentListener {
    private final IDocument document;
    private int endLineIndexOfRemovedText = -1;

    DocumentModelLines(IDocument document) {
        this.document = document;
        document.addDocumentListener((IDocumentListener)this);
        this.addLines(0, document.getNumberOfLines());
    }

    public void documentAboutToBeChanged(@Nullable DocumentEvent event) {
        if (event == null) {
            return;
        }
        try {
            switch (DocumentHelper.getEventType(event)) {
                case REPLACE: 
                case REMOVE: {
                    this.endLineIndexOfRemovedText = DocumentHelper.getEndLineIndexOfRemovedText(event);
                }
            }
        }
        catch (BadLocationException ex) {
            TMUIPlugin.logError((Exception)((Object)ex));
        }
    }

    public void documentChanged(@Nullable DocumentEvent event) {
        if (event == null) {
            return;
        }
        try {
            int startLineIndex = DocumentHelper.getStartLineIndex(event);
            switch (DocumentHelper.getEventType(event)) {
                case INSERT: {
                    int endLineIndexOfAddedText = DocumentHelper.getEndLineIndexOfAddedText(event);
                    boolean isFullLineInsert = DocumentHelper.getStartLineCharIndex(event) == 0 && event.getText().endsWith("\n");
                    int linesAdded = (isFullLineInsert ? 0 : 1) + (endLineIndexOfAddedText - startLineIndex);
                    this.replaceLines(startLineIndex, isFullLineInsert ? 0 : 1, linesAdded);
                    break;
                }
                case REMOVE: {
                    this.replaceLines(startLineIndex, 1 + (this.endLineIndexOfRemovedText - startLineIndex), 1);
                    break;
                }
                case REPLACE: {
                    int endLineIndexOfAddedText = DocumentHelper.getEndLineIndexOfAddedText(event);
                    boolean isFullLineInsert = DocumentHelper.getStartLineCharIndex(event) == 0 && event.getText().endsWith("\n");
                    this.replaceLines(startLineIndex, (isFullLineInsert ? 0 : 1) + (this.endLineIndexOfRemovedText - startLineIndex), (isFullLineInsert ? 0 : 1) + (endLineIndexOfAddedText - startLineIndex));
                }
            }
        }
        catch (BadLocationException ex) {
            TMUIPlugin.logError((Exception)((Object)ex));
        }
    }

    public String getLineText(int lineIndex) throws Exception {
        return DocumentHelper.getLineText(this.document, lineIndex, false);
    }

    public void dispose() {
        this.document.removeDocumentListener((IDocumentListener)this);
    }
}

