/**
 * Copyright (c) 2017, 2020 Kichwa Coders Ltd. and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */
package org.eclipse.lsp4j.debug;

/**
 * A hint for how to present the instruction in the UI.
 * <p>
 * <p>
 * A value of `invalid` may be used to indicate this instruction is 'filler' and cannot be reached by the program.
 * For example, unreadable memory addresses may be presented is 'invalid.'
 * <p>
 * This is an optional property.
 * <p>
 * Since 1.64
 */
@SuppressWarnings("all")
public enum DisassembledInstructionPresentationHint {
  NORMAL,

  INVALID;
}
